/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.examples.java.connectors;

import java.util.List;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.format.DecodingFormat;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.examples.java.connectors.ChangelogCsvDeserializer;
import org.apache.flink.table.types.DataType;
import org.apache.flink.types.RowKind;

public final class ChangelogCsvFormat
implements DecodingFormat<DeserializationSchema<RowData>> {
    private final String columnDelimiter;

    public ChangelogCsvFormat(String columnDelimiter) {
        this.columnDelimiter = columnDelimiter;
    }

    public DeserializationSchema<RowData> createRuntimeDecoder(DynamicTableSource.Context context, DataType producedDataType) {
        TypeInformation producedTypeInfo = context.createTypeInformation(producedDataType);
        DynamicTableSource.DataStructureConverter converter = context.createDataStructureConverter(producedDataType);
        List parsingTypes = producedDataType.getLogicalType().getChildren();
        return new ChangelogCsvDeserializer(parsingTypes, converter, (TypeInformation<RowData>)producedTypeInfo, this.columnDelimiter);
    }

    public ChangelogMode getChangelogMode() {
        return ChangelogMode.newBuilder().addContainedKind(RowKind.INSERT).addContainedKind(RowKind.DELETE).build();
    }
}

