/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.gateway.rest.message.statement;

import javax.annotation.Nullable;
import org.apache.flink.api.common.JobID;
import org.apache.flink.table.api.ResultKind;
import org.apache.flink.table.gateway.api.results.ResultSet;
import org.apache.flink.table.gateway.api.utils.SqlGatewayException;
import org.apache.flink.table.gateway.rest.message.statement.FetchResultsResponseBody;
import org.apache.flink.table.gateway.rest.serde.ResultInfo;

public class NotReadyFetchResultResponse
implements FetchResultsResponseBody {
    private final String nextResultUri;

    public NotReadyFetchResultResponse(String nextResultUri) {
        this.nextResultUri = nextResultUri;
    }

    @Override
    public ResultInfo getResults() {
        throw new SqlGatewayException("The result is not ready. Please fetch results until the result type is PAYLOAD or EOS.");
    }

    @Override
    public ResultSet.ResultType getResultType() {
        return ResultSet.ResultType.NOT_READY;
    }

    @Override
    @Nullable
    public String getNextResultUri() {
        return this.nextResultUri;
    }

    @Override
    public boolean isQueryResult() {
        throw new SqlGatewayException("Don't know whether a NOT_READY_RESULT is for a query. Please continue fetching results until the result type is PAYLOAD or EOS.");
    }

    @Override
    @Nullable
    public JobID getJobID() {
        throw new SqlGatewayException("Don't know the Job ID with NOT_READY_RESULT. Please continue fetching results until the result type is PAYLOAD or EOS.");
    }

    @Override
    public ResultKind getResultKind() {
        throw new SqlGatewayException("Don't know the ResultKind with NOT_READY_RESULT. Please continue fetching results until the result type is PAYLOAD or EOS.");
    }
}

