/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.gateway.rest.handler.statement;

import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.RestHandlerException;
import org.apache.flink.runtime.rest.handler.util.HandlerRequestUtils;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.MessageHeaders;
import org.apache.flink.table.gateway.api.SqlGatewayService;
import org.apache.flink.table.gateway.api.operation.OperationHandle;
import org.apache.flink.table.gateway.api.results.ResultSet;
import org.apache.flink.table.gateway.api.session.SessionHandle;
import org.apache.flink.table.gateway.api.utils.SqlGatewayException;
import org.apache.flink.table.gateway.rest.handler.AbstractSqlGatewayRestHandler;
import org.apache.flink.table.gateway.rest.header.statement.FetchResultsHeaders;
import org.apache.flink.table.gateway.rest.message.operation.OperationHandleIdPathParameter;
import org.apache.flink.table.gateway.rest.message.session.SessionHandleIdPathParameter;
import org.apache.flink.table.gateway.rest.message.statement.FetchResultResponseBodyImpl;
import org.apache.flink.table.gateway.rest.message.statement.FetchResultsMessageParameters;
import org.apache.flink.table.gateway.rest.message.statement.FetchResultsResponseBody;
import org.apache.flink.table.gateway.rest.message.statement.FetchResultsRowFormatQueryParameter;
import org.apache.flink.table.gateway.rest.message.statement.FetchResultsTokenPathParameter;
import org.apache.flink.table.gateway.rest.message.statement.NotReadyFetchResultResponse;
import org.apache.flink.table.gateway.rest.serde.ResultInfo;
import org.apache.flink.table.gateway.rest.util.RowDataLocalTimeZoneConverter;
import org.apache.flink.table.gateway.rest.util.RowFormat;
import org.apache.flink.table.gateway.rest.util.SqlGatewayRestAPIVersion;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;

public class FetchResultsHandler
extends AbstractSqlGatewayRestHandler<EmptyRequestBody, FetchResultsResponseBody, FetchResultsMessageParameters> {
    public FetchResultsHandler(SqlGatewayService service, Map<String, String> responseHeaders, MessageHeaders<EmptyRequestBody, FetchResultsResponseBody, FetchResultsMessageParameters> messageHeaders) {
        super(service, responseHeaders, messageHeaders);
    }

    @Override
    protected CompletableFuture<FetchResultsResponseBody> handleRequest(SqlGatewayRestAPIVersion version, @Nonnull HandlerRequest<EmptyRequestBody> request) throws RestHandlerException {
        ResultSet resultSet;
        SessionHandle sessionHandle = (SessionHandle)request.getPathParameter(SessionHandleIdPathParameter.class);
        OperationHandle operationHandle = (OperationHandle)request.getPathParameter(OperationHandleIdPathParameter.class);
        Long token = (Long)request.getPathParameter(FetchResultsTokenPathParameter.class);
        RowFormat rowFormat = (RowFormat)((Object)HandlerRequestUtils.getQueryParameter(request, FetchResultsRowFormatQueryParameter.class, (Object)((Object)RowFormat.JSON)));
        try {
            resultSet = this.service.fetchResults(sessionHandle, operationHandle, token, Integer.MAX_VALUE);
        }
        catch (Exception e) {
            throw new SqlGatewayException(e);
        }
        ResultSet.ResultType resultType = resultSet.getResultType();
        Long nextToken = resultSet.getNextToken();
        String nextResultUri = FetchResultsHeaders.buildNextUri(version, sessionHandle.getIdentifier().toString(), operationHandle.getIdentifier().toString(), nextToken, rowFormat);
        if (resultType == ResultSet.ResultType.NOT_READY) {
            return CompletableFuture.completedFuture(new NotReadyFetchResultResponse(nextResultUri));
        }
        RowDataLocalTimeZoneConverter timeZoneConverter = null;
        if (rowFormat == RowFormat.JSON) {
            List<LogicalType> logicalTypeList = resultSet.getResultSchema().getColumnDataTypes().stream().map(DataType::getLogicalType).collect(Collectors.toList());
            timeZoneConverter = new RowDataLocalTimeZoneConverter(logicalTypeList, (ReadableConfig)Configuration.fromMap(this.service.getSessionConfig(sessionHandle)));
        }
        return CompletableFuture.completedFuture(new FetchResultResponseBodyImpl(resultType, resultSet.isQueryResult(), resultSet.getJobID(), resultSet.getResultKind(), ResultInfo.createResultInfo(resultSet, rowFormat, timeZoneConverter), nextResultUri));
    }
}

