/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.gateway.cli;

import java.io.PrintStream;
import java.io.PrintWriter;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.flink.table.gateway.api.utils.SqlGatewayException;
import org.apache.flink.table.gateway.cli.SqlGatewayOptions;

public class SqlGatewayOptionsParser {
    public static final Option OPTION_HELP = Option.builder((String)"h").required(false).longOpt("help").desc("Show the help message with descriptions of all options.").build();
    public static final Option DYNAMIC_PROPERTY_OPTION = Option.builder((String)"D").argName("property=value").numberOfArgs(2).valueSeparator('=').desc("Use value for given property").build();

    public static SqlGatewayOptions parseSqlGatewayOptions(String[] args) {
        try {
            DefaultParser parser = new DefaultParser();
            CommandLine line = parser.parse(SqlGatewayOptionsParser.getSqlGatewayOptions(), args, true);
            return new SqlGatewayOptions(line.hasOption(OPTION_HELP.getOpt()), line.getOptionProperties(DYNAMIC_PROPERTY_OPTION.getOpt()));
        }
        catch (ParseException e) {
            throw new SqlGatewayException(e.getMessage());
        }
    }

    public static void printHelpSqlGateway(PrintStream writer) {
        writer.println();
        SqlGatewayOptionsParser.printHelpForStart(writer);
    }

    private static void printHelpForStart(PrintStream printStream) {
        PrintWriter writer = new PrintWriter(printStream);
        writer.println("Start the Flink SQL Gateway as a daemon to submit Flink SQL.");
        HelpFormatter formatter = new HelpFormatter();
        formatter.setLeftPadding(5);
        formatter.setWidth(80);
        writer.println("\n  Syntax: start [OPTIONS]");
        formatter.setSyntaxPrefix("  \"start\" options:");
        formatter.printOptions(writer, formatter.getWidth(), SqlGatewayOptionsParser.getSqlGatewayOptions(), formatter.getLeftPadding(), formatter.getDescPadding());
        writer.println();
        writer.flush();
    }

    private static Options getSqlGatewayOptions() {
        Options options = new Options();
        options.addOption(OPTION_HELP);
        options.addOption(DYNAMIC_PROPERTY_OPTION);
        return options;
    }
}

