/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.kafka.table;

import java.time.Duration;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.connector.base.DeliveryGuarantee;
import org.apache.flink.streaming.connectors.kafka.config.BoundedMode;
import org.apache.flink.streaming.connectors.kafka.config.StartupMode;
import org.apache.flink.streaming.connectors.kafka.table.KafkaConnectorOptions;
import org.apache.flink.streaming.connectors.kafka.table.KafkaConnectorOptionsUtil;
import org.apache.flink.streaming.connectors.kafka.table.KafkaDynamicSink;
import org.apache.flink.streaming.connectors.kafka.table.KafkaDynamicSource;
import org.apache.flink.streaming.connectors.kafka.table.SinkBufferFlushMode;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.ResolvedCatalogTable;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.catalog.UniqueConstraint;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.format.DecodingFormat;
import org.apache.flink.table.connector.format.EncodingFormat;
import org.apache.flink.table.connector.format.Format;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.factories.DeserializationFormatFactory;
import org.apache.flink.table.factories.DynamicTableFactory;
import org.apache.flink.table.factories.DynamicTableSinkFactory;
import org.apache.flink.table.factories.DynamicTableSourceFactory;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.factories.SerializationFormatFactory;
import org.apache.flink.table.types.DataType;
import org.apache.flink.types.RowKind;

public class UpsertKafkaDynamicTableFactory
implements DynamicTableSourceFactory,
DynamicTableSinkFactory {
    public static final String IDENTIFIER = "upsert-kafka";

    public String factoryIdentifier() {
        return IDENTIFIER;
    }

    public Set<ConfigOption<?>> requiredOptions() {
        HashSet options = new HashSet();
        options.add(KafkaConnectorOptions.PROPS_BOOTSTRAP_SERVERS);
        options.add(KafkaConnectorOptions.TOPIC);
        options.add(KafkaConnectorOptions.KEY_FORMAT);
        options.add(KafkaConnectorOptions.VALUE_FORMAT);
        return options;
    }

    public Set<ConfigOption<?>> optionalOptions() {
        HashSet options = new HashSet();
        options.add(KafkaConnectorOptions.KEY_FIELDS_PREFIX);
        options.add(KafkaConnectorOptions.VALUE_FIELDS_INCLUDE);
        options.add(KafkaConnectorOptions.SINK_PARALLELISM);
        options.add(KafkaConnectorOptions.SINK_BUFFER_FLUSH_INTERVAL);
        options.add(KafkaConnectorOptions.SINK_BUFFER_FLUSH_MAX_ROWS);
        return options;
    }

    public DynamicTableSource createDynamicTableSource(DynamicTableFactory.Context context) {
        FactoryUtil.TableFactoryHelper helper = FactoryUtil.createTableFactoryHelper((DynamicTableFactory)this, (DynamicTableFactory.Context)context);
        ReadableConfig tableOptions = helper.getOptions();
        DecodingFormat keyDecodingFormat = helper.discoverDecodingFormat(DeserializationFormatFactory.class, KafkaConnectorOptions.KEY_FORMAT);
        DecodingFormat valueDecodingFormat = helper.discoverDecodingFormat(DeserializationFormatFactory.class, KafkaConnectorOptions.VALUE_FORMAT);
        helper.validateExcept(new String[]{"properties."});
        UpsertKafkaDynamicTableFactory.validateSource(tableOptions, (Format)keyDecodingFormat, (Format)valueDecodingFormat, context.getPrimaryKeyIndexes());
        Tuple2<int[], int[]> keyValueProjections = this.createKeyValueProjections(context.getCatalogTable());
        String keyPrefix = tableOptions.getOptional(KafkaConnectorOptions.KEY_FIELDS_PREFIX).orElse(null);
        Properties properties = KafkaConnectorOptionsUtil.getKafkaProperties(context.getCatalogTable().getOptions());
        StartupMode earliest = StartupMode.EARLIEST;
        return new KafkaDynamicSource(context.getPhysicalRowDataType(), (DecodingFormat<DeserializationSchema<RowData>>)keyDecodingFormat, new DecodingFormatWrapper((DecodingFormat<DeserializationSchema<RowData>>)valueDecodingFormat), (int[])keyValueProjections.f0, (int[])keyValueProjections.f1, keyPrefix, KafkaConnectorOptionsUtil.getSourceTopics(tableOptions), KafkaConnectorOptionsUtil.getSourceTopicPattern(tableOptions), properties, earliest, Collections.emptyMap(), 0L, BoundedMode.UNBOUNDED, Collections.emptyMap(), 0L, true, context.getObjectIdentifier().asSummaryString());
    }

    public DynamicTableSink createDynamicTableSink(DynamicTableFactory.Context context) {
        FactoryUtil.TableFactoryHelper helper = FactoryUtil.createTableFactoryHelper((DynamicTableFactory)this, (DynamicTableFactory.Context)KafkaConnectorOptionsUtil.autoCompleteSchemaRegistrySubject(context));
        ReadableConfig tableOptions = helper.getOptions();
        EncodingFormat keyEncodingFormat = helper.discoverEncodingFormat(SerializationFormatFactory.class, KafkaConnectorOptions.KEY_FORMAT);
        EncodingFormat valueEncodingFormat = helper.discoverEncodingFormat(SerializationFormatFactory.class, KafkaConnectorOptions.VALUE_FORMAT);
        helper.validateExcept(new String[]{"properties."});
        UpsertKafkaDynamicTableFactory.validateSink(tableOptions, (Format)keyEncodingFormat, (Format)valueEncodingFormat, context.getPrimaryKeyIndexes());
        Tuple2<int[], int[]> keyValueProjections = this.createKeyValueProjections(context.getCatalogTable());
        String keyPrefix = tableOptions.getOptional(KafkaConnectorOptions.KEY_FIELDS_PREFIX).orElse(null);
        Properties properties = KafkaConnectorOptionsUtil.getKafkaProperties(context.getCatalogTable().getOptions());
        Integer parallelism = (Integer)tableOptions.get(KafkaConnectorOptions.SINK_PARALLELISM);
        int batchSize = (Integer)tableOptions.get(KafkaConnectorOptions.SINK_BUFFER_FLUSH_MAX_ROWS);
        Duration batchInterval = (Duration)tableOptions.get(KafkaConnectorOptions.SINK_BUFFER_FLUSH_INTERVAL);
        SinkBufferFlushMode flushMode = new SinkBufferFlushMode(batchSize, batchInterval.toMillis());
        return new KafkaDynamicSink(context.getPhysicalRowDataType(), context.getPhysicalRowDataType(), (EncodingFormat<SerializationSchema<RowData>>)keyEncodingFormat, new EncodingFormatWrapper((EncodingFormat<SerializationSchema<RowData>>)valueEncodingFormat), (int[])keyValueProjections.f0, (int[])keyValueProjections.f1, keyPrefix, (String)((List)tableOptions.get(KafkaConnectorOptions.TOPIC)).get(0), properties, null, DeliveryGuarantee.AT_LEAST_ONCE, true, flushMode, parallelism, (String)tableOptions.get(KafkaConnectorOptions.TRANSACTIONAL_ID_PREFIX));
    }

    private Tuple2<int[], int[]> createKeyValueProjections(ResolvedCatalogTable catalogTable) {
        ResolvedSchema schema = catalogTable.getResolvedSchema();
        List keyFields = ((UniqueConstraint)schema.getPrimaryKey().get()).getColumns();
        DataType physicalDataType = schema.toPhysicalRowDataType();
        Configuration tableOptions = Configuration.fromMap((Map)catalogTable.getOptions());
        tableOptions.set(KafkaConnectorOptions.KEY_FIELDS, (Object)keyFields);
        int[] keyProjection = KafkaConnectorOptionsUtil.createKeyFormatProjection((ReadableConfig)tableOptions, physicalDataType);
        int[] valueProjection = KafkaConnectorOptionsUtil.createValueFormatProjection((ReadableConfig)tableOptions, physicalDataType);
        return Tuple2.of((Object)keyProjection, (Object)valueProjection);
    }

    private static void validateSource(ReadableConfig tableOptions, Format keyFormat, Format valueFormat, int[] primaryKeyIndexes) {
        UpsertKafkaDynamicTableFactory.validateTopic(tableOptions);
        UpsertKafkaDynamicTableFactory.validateFormat(keyFormat, valueFormat, tableOptions);
        UpsertKafkaDynamicTableFactory.validatePKConstraints(primaryKeyIndexes);
    }

    private static void validateSink(ReadableConfig tableOptions, Format keyFormat, Format valueFormat, int[] primaryKeyIndexes) {
        UpsertKafkaDynamicTableFactory.validateTopic(tableOptions);
        UpsertKafkaDynamicTableFactory.validateFormat(keyFormat, valueFormat, tableOptions);
        UpsertKafkaDynamicTableFactory.validatePKConstraints(primaryKeyIndexes);
        UpsertKafkaDynamicTableFactory.validateSinkBufferFlush(tableOptions);
    }

    private static void validateTopic(ReadableConfig tableOptions) {
        List topic = (List)tableOptions.get(KafkaConnectorOptions.TOPIC);
        if (topic.size() > 1) {
            throw new ValidationException("The 'upsert-kafka' connector doesn't support topic list now. Please use single topic as the value of the parameter 'topic'.");
        }
    }

    private static void validateFormat(Format keyFormat, Format valueFormat, ReadableConfig tableOptions) {
        if (!keyFormat.getChangelogMode().containsOnly(RowKind.INSERT)) {
            String identifier = (String)tableOptions.get(KafkaConnectorOptions.KEY_FORMAT);
            throw new ValidationException(String.format("'upsert-kafka' connector doesn't support '%s' as key format, because '%s' is not in insert-only mode.", identifier, identifier));
        }
        if (!valueFormat.getChangelogMode().containsOnly(RowKind.INSERT)) {
            String identifier = (String)tableOptions.get(KafkaConnectorOptions.VALUE_FORMAT);
            throw new ValidationException(String.format("'upsert-kafka' connector doesn't support '%s' as value format, because '%s' is not in insert-only mode.", identifier, identifier));
        }
    }

    private static void validatePKConstraints(int[] schema) {
        if (schema.length == 0) {
            throw new ValidationException("'upsert-kafka' tables require to define a PRIMARY KEY constraint. The PRIMARY KEY specifies which columns should be read from or write to the Kafka message key. The PRIMARY KEY also defines records in the 'upsert-kafka' table should update or delete on which keys.");
        }
    }

    private static void validateSinkBufferFlush(ReadableConfig tableOptions) {
        int flushMaxRows = (Integer)tableOptions.get(KafkaConnectorOptions.SINK_BUFFER_FLUSH_MAX_ROWS);
        long flushIntervalMs = ((Duration)tableOptions.get(KafkaConnectorOptions.SINK_BUFFER_FLUSH_INTERVAL)).toMillis();
        if (flushMaxRows > 0 && flushIntervalMs > 0L) {
            return;
        }
        if (flushMaxRows <= 0 && flushIntervalMs <= 0L) {
            return;
        }
        throw new ValidationException(String.format("'%s' and '%s' must be set to be greater than zero together to enable sink buffer flushing.", KafkaConnectorOptions.SINK_BUFFER_FLUSH_MAX_ROWS.key(), KafkaConnectorOptions.SINK_BUFFER_FLUSH_INTERVAL.key()));
    }

    protected static class EncodingFormatWrapper
    implements EncodingFormat<SerializationSchema<RowData>> {
        private final EncodingFormat<SerializationSchema<RowData>> innerEncodingFormat;
        public static final ChangelogMode SINK_CHANGELOG_MODE = ChangelogMode.newBuilder().addContainedKind(RowKind.INSERT).addContainedKind(RowKind.UPDATE_AFTER).addContainedKind(RowKind.DELETE).build();

        public EncodingFormatWrapper(EncodingFormat<SerializationSchema<RowData>> innerEncodingFormat) {
            this.innerEncodingFormat = innerEncodingFormat;
        }

        public SerializationSchema<RowData> createRuntimeEncoder(DynamicTableSink.Context context, DataType consumedDataType) {
            return (SerializationSchema)this.innerEncodingFormat.createRuntimeEncoder(context, consumedDataType);
        }

        public ChangelogMode getChangelogMode() {
            return SINK_CHANGELOG_MODE;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            EncodingFormatWrapper that = (EncodingFormatWrapper)obj;
            return Objects.equals(this.innerEncodingFormat, that.innerEncodingFormat);
        }

        public int hashCode() {
            return Objects.hash(this.innerEncodingFormat);
        }
    }

    protected static class DecodingFormatWrapper
    implements DecodingFormat<DeserializationSchema<RowData>> {
        private final DecodingFormat<DeserializationSchema<RowData>> innerDecodingFormat;
        private static final ChangelogMode SOURCE_CHANGELOG_MODE = ChangelogMode.newBuilder().addContainedKind(RowKind.UPDATE_AFTER).addContainedKind(RowKind.DELETE).build();

        public DecodingFormatWrapper(DecodingFormat<DeserializationSchema<RowData>> innerDecodingFormat) {
            this.innerDecodingFormat = innerDecodingFormat;
        }

        public DeserializationSchema<RowData> createRuntimeDecoder(DynamicTableSource.Context context, DataType producedDataType) {
            return (DeserializationSchema)this.innerDecodingFormat.createRuntimeDecoder(context, producedDataType);
        }

        public ChangelogMode getChangelogMode() {
            return SOURCE_CHANGELOG_MODE;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            DecodingFormatWrapper that = (DecodingFormatWrapper)obj;
            return Objects.equals(this.innerDecodingFormat, that.innerDecodingFormat);
        }

        public int hashCode() {
            return Objects.hash(this.innerDecodingFormat);
        }
    }
}

