/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.kafka.table;

import javax.annotation.Nullable;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.connector.kafka.sink.KafkaRecordSerializationSchema;
import org.apache.flink.streaming.connectors.kafka.partitioner.FlinkKafkaPartitioner;
import org.apache.flink.streaming.connectors.kafka.table.KafkaDynamicSink;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.types.RowKind;
import org.apache.flink.util.Preconditions;
import org.apache.kafka.clients.producer.ProducerRecord;

class DynamicKafkaRecordSerializationSchema
implements KafkaRecordSerializationSchema<RowData> {
    private final String topic;
    private final FlinkKafkaPartitioner<RowData> partitioner;
    @Nullable
    private final SerializationSchema<RowData> keySerialization;
    private final SerializationSchema<RowData> valueSerialization;
    private final RowData.FieldGetter[] keyFieldGetters;
    private final RowData.FieldGetter[] valueFieldGetters;
    private final boolean hasMetadata;
    private final int[] metadataPositions;
    private final boolean upsertMode;

    DynamicKafkaRecordSerializationSchema(String topic, @Nullable FlinkKafkaPartitioner<RowData> partitioner, @Nullable SerializationSchema<RowData> keySerialization, SerializationSchema<RowData> valueSerialization, RowData.FieldGetter[] keyFieldGetters, RowData.FieldGetter[] valueFieldGetters, boolean hasMetadata, int[] metadataPositions, boolean upsertMode) {
        if (upsertMode) {
            Preconditions.checkArgument((keySerialization != null && keyFieldGetters.length > 0 ? 1 : 0) != 0, (Object)"Key must be set in upsert mode for serialization schema.");
        }
        this.topic = (String)Preconditions.checkNotNull((Object)topic);
        this.partitioner = partitioner;
        this.keySerialization = keySerialization;
        this.valueSerialization = (SerializationSchema)Preconditions.checkNotNull(valueSerialization);
        this.keyFieldGetters = keyFieldGetters;
        this.valueFieldGetters = valueFieldGetters;
        this.hasMetadata = hasMetadata;
        this.metadataPositions = metadataPositions;
        this.upsertMode = upsertMode;
    }

    @Override
    public ProducerRecord<byte[], byte[]> serialize(RowData consumedRow, KafkaRecordSerializationSchema.KafkaSinkContext context, Long timestamp) {
        byte[] valueSerialized;
        byte[] keySerialized;
        if (this.keySerialization == null && !this.hasMetadata) {
            byte[] valueSerialized2 = this.valueSerialization.serialize((Object)consumedRow);
            return new ProducerRecord<Object, byte[]>(this.topic, this.extractPartition(consumedRow, null, valueSerialized2, context.getPartitionsForTopic(this.topic)), null, valueSerialized2);
        }
        if (this.keySerialization == null) {
            keySerialized = null;
        } else {
            RowData keyRow = DynamicKafkaRecordSerializationSchema.createProjectedRow(consumedRow, RowKind.INSERT, this.keyFieldGetters);
            keySerialized = this.keySerialization.serialize((Object)keyRow);
        }
        RowKind kind = consumedRow.getRowKind();
        if (this.upsertMode) {
            if (kind == RowKind.DELETE || kind == RowKind.UPDATE_BEFORE) {
                valueSerialized = null;
            } else {
                RowData valueRow = DynamicKafkaRecordSerializationSchema.createProjectedRow(consumedRow, kind, this.valueFieldGetters);
                valueRow.setRowKind(RowKind.INSERT);
                valueSerialized = this.valueSerialization.serialize((Object)valueRow);
            }
        } else {
            RowData valueRow = DynamicKafkaRecordSerializationSchema.createProjectedRow(consumedRow, kind, this.valueFieldGetters);
            valueSerialized = this.valueSerialization.serialize((Object)valueRow);
        }
        return new ProducerRecord<byte[], byte[]>(this.topic, this.extractPartition(consumedRow, keySerialized, valueSerialized, context.getPartitionsForTopic(this.topic)), (Long)this.readMetadata(consumedRow, KafkaDynamicSink.WritableMetadata.TIMESTAMP), keySerialized, valueSerialized, (Iterable)this.readMetadata(consumedRow, KafkaDynamicSink.WritableMetadata.HEADERS));
    }

    @Override
    public void open(SerializationSchema.InitializationContext context, KafkaRecordSerializationSchema.KafkaSinkContext sinkContext) throws Exception {
        if (this.keySerialization != null) {
            this.keySerialization.open(context);
        }
        if (this.partitioner != null) {
            this.partitioner.open(sinkContext.getParallelInstanceId(), sinkContext.getNumberOfParallelInstances());
        }
        this.valueSerialization.open(context);
    }

    private Integer extractPartition(RowData consumedRow, @Nullable byte[] keySerialized, byte[] valueSerialized, int[] partitions) {
        if (this.partitioner != null) {
            return this.partitioner.partition(consumedRow, keySerialized, valueSerialized, this.topic, partitions);
        }
        return null;
    }

    static RowData createProjectedRow(RowData consumedRow, RowKind kind, RowData.FieldGetter[] fieldGetters) {
        int arity = fieldGetters.length;
        GenericRowData genericRowData = new GenericRowData(kind, arity);
        for (int fieldPos = 0; fieldPos < arity; ++fieldPos) {
            genericRowData.setField(fieldPos, fieldGetters[fieldPos].getFieldOrNull(consumedRow));
        }
        return genericRowData;
    }

    private <T> T readMetadata(RowData consumedRow, KafkaDynamicSink.WritableMetadata metadata) {
        int pos = this.metadataPositions[metadata.ordinal()];
        if (pos < 0) {
            return null;
        }
        return (T)metadata.converter.read(consumedRow, pos);
    }
}

