/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.implcore.tags;

import com.google.common.base.Preconditions;
import io.opencensus.implcore.internal.CurrentState;
import io.opencensus.implcore.tags.TaggerImpl;
import io.opencensus.implcore.tags.propagation.TagPropagationComponentImpl;
import io.opencensus.tags.Tagger;
import io.opencensus.tags.TaggingState;
import io.opencensus.tags.TagsComponent;
import io.opencensus.tags.propagation.TagPropagationComponent;

public class TagsComponentImplBase
extends TagsComponent {
    private static final CurrentState.State DEFAULT_STATE = CurrentState.State.ENABLED;
    private final CurrentState currentState = new CurrentState(DEFAULT_STATE);
    private final Tagger tagger = new TaggerImpl(this.currentState);
    private final TagPropagationComponent tagPropagationComponent = new TagPropagationComponentImpl(this.currentState);

    @Override
    public Tagger getTagger() {
        return this.tagger;
    }

    @Override
    public TagPropagationComponent getTagPropagationComponent() {
        return this.tagPropagationComponent;
    }

    @Override
    public TaggingState getState() {
        return TagsComponentImplBase.stateToTaggingState(this.currentState.get());
    }

    @Override
    @Deprecated
    public void setState(TaggingState newState) {
        this.currentState.set(TagsComponentImplBase.taggingStateToState(Preconditions.checkNotNull(newState, "newState")));
    }

    private static CurrentState.State taggingStateToState(TaggingState taggingState) {
        return taggingState == TaggingState.ENABLED ? CurrentState.State.ENABLED : CurrentState.State.DISABLED;
    }

    private static TaggingState stateToTaggingState(CurrentState.State state) {
        return state == CurrentState.State.ENABLED ? TaggingState.ENABLED : TaggingState.DISABLED;
    }
}

