/*
 * Decompiled with CFR 0.152.
 */
package com.google.monitoring.v3;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class GroupName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding("projects/{project}/groups/{group}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String group;

    public String getProject() {
        return this.project;
    }

    public String getGroup() {
        return this.group;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private GroupName(Builder builder) {
        this.project = Preconditions.checkNotNull(builder.getProject());
        this.group = Preconditions.checkNotNull(builder.getGroup());
    }

    public static GroupName of(String project, String group) {
        return GroupName.newBuilder().setProject(project).setGroup(group).build();
    }

    public static String format(String project, String group) {
        return GroupName.newBuilder().setProject(project).setGroup(group).build().toString();
    }

    public static GroupName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map<String, String> matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "GroupName.parse: formattedString not in valid format");
        return GroupName.of(matchMap.get("project"), matchMap.get("group"));
    }

    public static List<GroupName> parseList(List<String> formattedStrings) {
        ArrayList<GroupName> list = new ArrayList<GroupName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(GroupName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<GroupName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (GroupName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            GroupName groupName = this;
            synchronized (groupName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder<String, String> fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put("project", this.project);
                    fieldMapBuilder.put("group", this.group);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    @Override
    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate("project", this.project, "group", this.group);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof GroupName) {
            GroupName that = (GroupName)o;
            return this.project.equals(that.project) && this.group.equals(that.group);
        }
        return false;
    }

    public int hashCode() {
        int h2 = 1;
        h2 *= 1000003;
        h2 ^= this.project.hashCode();
        h2 *= 1000003;
        return h2 ^= this.group.hashCode();
    }

    public static class Builder {
        private String project;
        private String group;

        public String getProject() {
            return this.project;
        }

        public String getGroup() {
            return this.group;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setGroup(String group) {
            this.group = group;
            return this;
        }

        private Builder() {
        }

        private Builder(GroupName groupName) {
            this.project = groupName.project;
            this.group = groupName.group;
        }

        public GroupName build() {
            return new GroupName(this);
        }
    }
}

