/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio.cooplock;

import com.google.cloud.hadoop.gcsio.FileInfo;
import com.google.cloud.hadoop.gcsio.ForwardingGoogleCloudStorage;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorage;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageImpl;
import com.google.cloud.hadoop.gcsio.StorageResourceId;
import com.google.cloud.hadoop.gcsio.cooplock.CoopLockOperationDao;
import com.google.cloud.hadoop.gcsio.cooplock.CoopLockOperationType;
import com.google.cloud.hadoop.gcsio.cooplock.CoopLockRecordsDao;
import com.google.cloud.hadoop.gcsio.cooplock.CoopLockUtils;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.URI;
import java.time.Instant;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Future;

public class CoopLockOperationRename {
    private final String operationId = UUID.randomUUID().toString();
    private final Instant operationInstant = Instant.now();
    private final StorageResourceId srcResourceId;
    private final StorageResourceId dstResourceId;
    private final CoopLockRecordsDao coopLockRecordsDao;
    private final CoopLockOperationDao coopLockOperationDao;
    private Future<?> lockUpdateFuture;

    private CoopLockOperationRename(GoogleCloudStorageImpl gcs, StorageResourceId srcResourceId, StorageResourceId dstResourceId) {
        this.srcResourceId = srcResourceId;
        this.dstResourceId = dstResourceId;
        this.coopLockRecordsDao = new CoopLockRecordsDao(gcs);
        this.coopLockOperationDao = new CoopLockOperationDao(gcs);
    }

    public static CoopLockOperationRename create(GoogleCloudStorage gcs, URI src, URI dst) {
        while (gcs instanceof ForwardingGoogleCloudStorage) {
            gcs = ((ForwardingGoogleCloudStorage)gcs).getDelegate();
        }
        Preconditions.checkArgument(gcs instanceof GoogleCloudStorageImpl, "gcs should be instance of %s, but was %s", GoogleCloudStorageImpl.class, gcs.getClass());
        return new CoopLockOperationRename((GoogleCloudStorageImpl)gcs, StorageResourceId.fromUriPath(CoopLockUtils.normalizeLockedResource(src), true), StorageResourceId.fromUriPath(CoopLockUtils.normalizeLockedResource(dst), true));
    }

    public void lock() {
        try {
            this.coopLockRecordsDao.lockPaths(this.operationId, this.operationInstant, CoopLockOperationType.RENAME, this.srcResourceId, this.dstResourceId);
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Failed to acquire lock %s operation", this), e);
        }
    }

    public void persistAndScheduleRenewal(Map<FileInfo, URI> srcToDstItemNames, Map<FileInfo, URI> srcToDstMarkerItemNames) {
        try {
            this.lockUpdateFuture = this.coopLockOperationDao.persistRenameOperation(this.operationId, this.operationInstant, this.srcResourceId, this.dstResourceId, srcToDstItemNames, srcToDstMarkerItemNames);
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Failed to persist %s operation", this), e);
        }
    }

    public void checkpoint() {
        try {
            this.coopLockOperationDao.checkpointRenameOperation(this.srcResourceId.getBucketName(), this.operationId, this.operationInstant, true);
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Failed to checkpoint %s operation", this), e);
        }
    }

    public void unlock() {
        try {
            this.coopLockRecordsDao.unlockPaths(this.operationId, this.srcResourceId, this.dstResourceId);
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Failed to release unlock for %s operation", this), e);
        }
    }

    public void cancelRenewal() {
        this.lockUpdateFuture.cancel(false);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("operationId", this.operationId).add("operationInstant", this.operationInstant).add("srcResourceId", this.srcResourceId).add("dstResourceId", this.dstResourceId).toString();
    }
}

