/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.fs.gcs.auth;

import com.google.cloud.hadoop.fs.gcs.auth.DelegationTokenIOException;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.DtFetcher;
import org.apache.hadoop.security.token.Token;

public class GcsDtFetcher
implements DtFetcher {
    @Override
    public Text getServiceName() {
        return new Text("gs");
    }

    @Override
    public boolean isTokenRequired() {
        return UserGroupInformation.isSecurityEnabled();
    }

    @Override
    public Token<?> addDelegationTokens(Configuration conf, Credentials creds, String renewer, String url) throws Exception {
        FileSystem fs;
        Token<?> token;
        if (!url.startsWith("gs")) {
            url = "gs://" + url;
        }
        if ((token = (fs = FileSystem.get(URI.create(url), conf)).getDelegationToken(renewer)) == null) {
            throw new DelegationTokenIOException("Filesystem not generating Delegation Tokens: " + url);
        }
        creds.addToken(token.getService(), token);
        return token;
    }
}

