/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.logical;

import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexNode;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.catalog.WatermarkSpec;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.connector.source.abilities.SupportsSourceWatermark;
import org.apache.flink.table.connector.source.abilities.SupportsWatermarkPushDown;
import org.apache.flink.table.expressions.ResolvedExpression;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.plan.abilities.source.SourceAbilityContext;
import org.apache.flink.table.planner.plan.abilities.source.SourceAbilitySpec;
import org.apache.flink.table.planner.plan.abilities.source.SourceAbilitySpecBase;
import org.apache.flink.table.planner.plan.abilities.source.SourceWatermarkSpec;
import org.apache.flink.table.planner.plan.abilities.source.WatermarkPushDownSpec;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalTableSourceScan;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalWatermarkAssigner;
import org.apache.flink.table.planner.plan.schema.TableSourceTable;
import org.apache.flink.table.planner.utils.ShortcutUtils;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.watermark.WatermarkParams;

public abstract class PushWatermarkIntoTableSourceScanRuleBase
extends RelOptRule {
    public PushWatermarkIntoTableSourceScanRuleBase(RelOptRuleOperand operand, String description) {
        super(operand, description);
    }

    protected FlinkLogicalTableSourceScan getNewScan(FlinkLogicalWatermarkAssigner watermarkAssigner, RexNode watermarkExpr, FlinkLogicalTableSourceScan scan, TableConfig tableConfig, boolean useWatermarkAssignerRowType) {
        SourceAbilitySpecBase abilitySpec;
        TableSourceTable tableSourceTable = scan.getTable().unwrap(TableSourceTable.class);
        DynamicTableSource newDynamicTableSource = tableSourceTable.tableSource().copy();
        boolean isSourceWatermark = newDynamicTableSource instanceof SupportsSourceWatermark && this.hasSourceWatermarkDeclaration(watermarkExpr);
        RelDataType newType = useWatermarkAssignerRowType ? watermarkAssigner.getRowType() : scan.getRowType();
        RowType producedType = (RowType)FlinkTypeFactory.toLogicalType(newType);
        SourceAbilityContext abilityContext = SourceAbilityContext.from(scan);
        if (isSourceWatermark) {
            SourceWatermarkSpec sourceWatermarkSpec = new SourceWatermarkSpec(true, producedType);
            sourceWatermarkSpec.apply(newDynamicTableSource, abilityContext);
            abilitySpec = sourceWatermarkSpec;
        } else {
            Duration globalIdleTimeout = (Duration)tableConfig.get(ExecutionConfigOptions.TABLE_EXEC_SOURCE_IDLE_TIMEOUT);
            long globalIdleTimeoutMillis = !globalIdleTimeout.isZero() && !globalIdleTimeout.isNegative() ? globalIdleTimeout.toMillis() : -1L;
            Optional<RelHint> optionsHintOptional = scan.getHints().stream().filter(relHint -> relHint.hintName.equalsIgnoreCase("OPTIONS")).findFirst();
            Configuration hintOptions = optionsHintOptional.map(relHint -> Configuration.fromMap(relHint.kvOptions)).orElseGet(Configuration::new);
            RelOptTable table = scan.getTable();
            Configuration tableOptions = Optional.of(table).filter(TableSourceTable.class::isInstance).map(t -> {
                Map tableConfigs = ((TableSourceTable)t).contextResolvedTable().getResolvedTable().getOptions();
                return Configuration.fromMap((Map)tableConfigs);
            }).orElseGet(Configuration::new);
            WatermarkParams watermarkParams = this.parseWatermarkParams(hintOptions, tableOptions);
            WatermarkPushDownSpec watermarkPushDownSpec = new WatermarkPushDownSpec(watermarkExpr, globalIdleTimeoutMillis, producedType, watermarkParams);
            watermarkPushDownSpec.apply(newDynamicTableSource, abilityContext);
            abilitySpec = watermarkPushDownSpec;
        }
        TableSourceTable newTableSourceTable = tableSourceTable.copy(newDynamicTableSource, newType, new SourceAbilitySpec[]{abilitySpec});
        return FlinkLogicalTableSourceScan.create(scan.getCluster(), scan.getHints(), newTableSourceTable);
    }

    protected boolean supportsWatermarkPushDown(FlinkLogicalTableSourceScan scan) {
        TableSourceTable tableSourceTable = scan.getTable().unwrap(TableSourceTable.class);
        if (tableSourceTable == null) {
            return false;
        }
        DynamicTableSource tableSource = tableSourceTable.tableSource();
        return tableSource instanceof SupportsWatermarkPushDown || tableSource instanceof SupportsSourceWatermark && this.hasSourceWatermarkDeclaration(tableSourceTable);
    }

    private boolean hasSourceWatermarkDeclaration(TableSourceTable table) {
        ResolvedSchema schema = table.contextResolvedTable().getResolvedSchema();
        List specs = schema.getWatermarkSpecs();
        if (specs.size() != 1) {
            return false;
        }
        ResolvedExpression watermarkExpr = ((WatermarkSpec)specs.get(0)).getWatermarkExpression();
        FunctionDefinition function = ShortcutUtils.unwrapFunctionDefinition(watermarkExpr);
        return function == BuiltInFunctionDefinitions.SOURCE_WATERMARK;
    }

    private boolean hasSourceWatermarkDeclaration(RexNode rexNode) {
        FunctionDefinition function = ShortcutUtils.unwrapFunctionDefinition(rexNode);
        return function == BuiltInFunctionDefinitions.SOURCE_WATERMARK;
    }

    private WatermarkParams parseWatermarkParams(Configuration hintOptions, Configuration tableOptions) {
        WatermarkParams.WatermarkParamsBuilder builder = WatermarkParams.builder();
        this.getOptions(FactoryUtil.WATERMARK_EMIT_STRATEGY, hintOptions, tableOptions).ifPresent(arg_0 -> ((WatermarkParams.WatermarkParamsBuilder)builder).emitStrategy(arg_0));
        this.getOptions(FactoryUtil.WATERMARK_ALIGNMENT_GROUP, hintOptions, tableOptions).ifPresent(arg_0 -> ((WatermarkParams.WatermarkParamsBuilder)builder).alignGroupName(arg_0));
        this.getOptions(FactoryUtil.WATERMARK_ALIGNMENT_MAX_DRIFT, hintOptions, tableOptions).ifPresent(arg_0 -> ((WatermarkParams.WatermarkParamsBuilder)builder).alignMaxDrift(arg_0));
        this.getOptions(FactoryUtil.WATERMARK_ALIGNMENT_UPDATE_INTERVAL, hintOptions, tableOptions).ifPresent(arg_0 -> ((WatermarkParams.WatermarkParamsBuilder)builder).alignUpdateInterval(arg_0));
        this.getOptions(FactoryUtil.SOURCE_IDLE_TIMEOUT, hintOptions, tableOptions).ifPresent(timeout -> builder.sourceIdleTimeout(timeout.toMillis()));
        return builder.build();
    }

    private <T> Optional<T> getOptions(ConfigOption<T> option, Configuration priorityOptions, Configuration secondOptions) {
        Optional result = priorityOptions.getOptional(option);
        return result.isPresent() ? result : secondOptions.getOptional(option);
    }
}

