/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.physical.stream;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Calc;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexProgram;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.InputProperty;
import org.apache.flink.table.planner.plan.nodes.exec.stream.StreamExecAsyncCalc;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalCalcBase;
import org.apache.flink.table.planner.plan.utils.AsyncUtil;
import org.apache.flink.table.planner.utils.ShortcutUtils;

public class StreamPhysicalAsyncCalc
extends StreamPhysicalCalcBase {
    private final RelOptCluster cluster;
    private final RexProgram calcProgram;
    private final RelDataType outputRowType;

    public StreamPhysicalAsyncCalc(RelOptCluster cluster, RelTraitSet traitSet, RelNode inputRel, RexProgram calcProgram, RelDataType outputRowType) {
        super(cluster, traitSet, inputRel, calcProgram, outputRowType);
        this.cluster = cluster;
        this.calcProgram = calcProgram;
        this.outputRowType = outputRowType;
    }

    @Override
    public Calc copy(RelTraitSet traitSet, RelNode child, RexProgram program) {
        return new StreamPhysicalAsyncCalc(this.cluster, traitSet, child, program, this.outputRowType);
    }

    @Override
    public ExecNode<?> translateToExecNode() {
        List<RexNode> projection = this.calcProgram.getProjectList().stream().map(this.calcProgram::expandLocalRef).collect(Collectors.toList());
        if (this.calcProgram.getCondition() != null) {
            throw new IllegalStateException("The condition of StreamPhysicalAsyncCalc should be null.");
        }
        if (projection.stream().filter(AsyncUtil::containsAsyncCall).count() > 1L) {
            throw new IllegalStateException("Only a single async projection is allowed in StreamPhysicalAsyncCalc.");
        }
        return new StreamExecAsyncCalc((ReadableConfig)ShortcutUtils.unwrapTableConfig(this), projection, InputProperty.DEFAULT, FlinkTypeFactory.toLogicalRowType(this.getRowType()), this.getRelDetailedDescription());
    }
}

