/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.physical.batch;

import java.io.Serializable;
import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollationTraitDef;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory$;
import org.apache.flink.table.planner.plan.cost.FlinkCost$;
import org.apache.flink.table.planner.plan.cost.FlinkCostFactory;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.InputProperty;
import org.apache.flink.table.planner.plan.nodes.exec.batch.BatchExecSortMergeJoin;
import org.apache.flink.table.planner.plan.nodes.physical.batch.BatchPhysicalJoinBase;
import org.apache.flink.table.planner.plan.trait.FlinkRelDistribution;
import org.apache.flink.table.planner.plan.trait.FlinkRelDistributionTraitDef$;
import org.apache.flink.table.planner.plan.utils.FlinkRelMdUtil$;
import org.apache.flink.table.planner.plan.utils.FlinkRelOptUtil$;
import org.apache.flink.table.planner.plan.utils.JoinTypeUtil;
import org.apache.flink.table.planner.plan.utils.JoinUtil$;
import org.apache.flink.table.planner.utils.ShortcutUtils;
import org.apache.flink.table.runtime.operators.join.FlinkJoinType;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableLike;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005]d\u0001B\u0001\u0003\u0001U\u0011!DQ1uG\"\u0004\u0006._:jG\u0006d7k\u001c:u\u001b\u0016\u0014x-\u001a&pS:T!a\u0001\u0003\u0002\u000b\t\fGo\u00195\u000b\u0005\u00151\u0011\u0001\u00039isNL7-\u00197\u000b\u0005\u001dA\u0011!\u00028pI\u0016\u001c(BA\u0005\u000b\u0003\u0011\u0001H.\u00198\u000b\u0005-a\u0011a\u00029mC:tWM\u001d\u0006\u0003\u001b9\tQ\u0001^1cY\u0016T!a\u0004\t\u0002\u000b\u0019d\u0017N\\6\u000b\u0005E\u0011\u0012AB1qC\u000eDWMC\u0001\u0014\u0003\ry'oZ\u0002\u0001'\t\u0001a\u0003\u0005\u0002\u001815\t!!\u0003\u0002\u001a\u0005\t)\")\u0019;dQBC\u0017p]5dC2Tu.\u001b8CCN,\u0007\u0002C\u000e\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u000f\u0002\u000f\rdWo\u001d;feB\u0011Q$I\u0007\u0002=)\u0011\u0011b\b\u0006\u0003AA\tqaY1mG&$X-\u0003\u0002#=\ti!+\u001a7PaR\u001cE.^:uKJD\u0001\u0002\n\u0001\u0003\u0002\u0003\u0006I!J\u0001\tiJ\f\u0017\u000e^*fiB\u0011QDJ\u0005\u0003Oy\u00111BU3m)J\f\u0017\u000e^*fi\"A\u0011\u0006\u0001B\u0001B\u0003%!&A\u0004mK\u001a$(+\u001a7\u0011\u0005-rS\"\u0001\u0017\u000b\u00055z\u0012a\u0001:fY&\u0011q\u0006\f\u0002\b%\u0016dgj\u001c3f\u0011!\t\u0004A!A!\u0002\u0013Q\u0013\u0001\u0003:jO\"$(+\u001a7\t\u0011M\u0002!\u0011!Q\u0001\nQ\n\u0011bY8oI&$\u0018n\u001c8\u0011\u0005UBT\"\u0001\u001c\u000b\u0005]z\u0012a\u0001:fq&\u0011\u0011H\u000e\u0002\b%\u0016Dhj\u001c3f\u0011!Y\u0004A!A!\u0002\u0013a\u0014\u0001\u00036pS:$\u0016\u0010]3\u0011\u0005u\u0002U\"\u0001 \u000b\u0005}b\u0013\u0001B2pe\u0016L!!\u0011 \u0003\u0017){\u0017N\u001c*fYRK\b/\u001a\u0005\t\u0007\u0002\u0011)\u0019!C\u0001\t\u0006QA.\u001a4u'>\u0014H/\u001a3\u0016\u0003\u0015\u0003\"AR%\u000e\u0003\u001dS\u0011\u0001S\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0015\u001e\u0013qAQ8pY\u0016\fg\u000e\u0003\u0005M\u0001\t\u0005\t\u0015!\u0003F\u0003-aWM\u001a;T_J$X\r\u001a\u0011\t\u00119\u0003!Q1A\u0005\u0002\u0011\u000b1B]5hQR\u001cvN\u001d;fI\"A\u0001\u000b\u0001B\u0001B\u0003%Q)\u0001\u0007sS\u001eDGoU8si\u0016$\u0007\u0005C\u0003S\u0001\u0011\u00051+\u0001\u0004=S:LGO\u0010\u000b\n)V3v\u000bW-[7r\u0003\"a\u0006\u0001\t\u000bm\t\u0006\u0019\u0001\u000f\t\u000b\u0011\n\u0006\u0019A\u0013\t\u000b%\n\u0006\u0019\u0001\u0016\t\u000bE\n\u0006\u0019\u0001\u0016\t\u000bM\n\u0006\u0019\u0001\u001b\t\u000bm\n\u0006\u0019\u0001\u001f\t\u000b\r\u000b\u0006\u0019A#\t\u000b9\u000b\u0006\u0019A#\t\u000by\u0003A\u0011C0\u00021%\u001cX*\u001a:hK*{\u0017N\\*vaB|'\u000f^3e)f\u0004X\r\u0006\u0002FA\")\u0011-\u0018a\u0001E\u0006Y!n\\5o%\u0016dG+\u001f9f!\t\u0019'.D\u0001e\u0015\t)g-\u0001\u0003k_&t'BA4i\u0003%y\u0007/\u001a:bi>\u00148O\u0003\u0002j\u0019\u00059!/\u001e8uS6,\u0017BA6e\u000551E.\u001b8l\u0015>Lg\u000eV=qK\")Q\u000e\u0001C!]\u0006!1m\u001c9z)\u001dy'o];xsj\u0004\"!\u00109\n\u0005Et$\u0001\u0002&pS:DQ\u0001\n7A\u0002\u0015BQ\u0001\u001e7A\u0002Q\nQbY8oI&$\u0018n\u001c8FqB\u0014\b\"\u0002<m\u0001\u0004Q\u0013\u0001\u00027fMRDQ\u0001\u001f7A\u0002)\nQA]5hQRDQa\u000f7A\u0002qBQa\u001f7A\u0002\u0015\u000bAb]3nS*{\u0017N\u001c#p]\u0016DQ! \u0001\u0005By\fA\"\u001a=qY\u0006Lg\u000eV3s[N$2a`A\u0003!\rY\u0013\u0011A\u0005\u0004\u0003\u0007a#!\u0003*fY^\u0013\u0018\u000e^3s\u0011\u0019\t9\u0001 a\u0001\u007f\u0006\u0011\u0001o\u001e\u0005\b\u0003\u0017\u0001A\u0011IA\u0007\u0003=\u0019w.\u001c9vi\u0016\u001cV\r\u001c4D_N$HCBA\b\u0003+\ti\u0002E\u0002\u001e\u0003#I1!a\u0005\u001f\u0005)\u0011V\r\\(qi\u000e{7\u000f\u001e\u0005\b\u0017\u0005%\u0001\u0019AA\f!\ri\u0012\u0011D\u0005\u0004\u00037q\"!\u0004*fY>\u0003H\u000f\u00157b]:,'\u000f\u0003\u0005\u0002 \u0005%\u0001\u0019AA\u0011\u0003\ti\u0017\u000f\u0005\u0003\u0002$\u0005%RBAA\u0013\u0015\r\t9\u0003L\u0001\t[\u0016$\u0018\rZ1uC&!\u00111FA\u0013\u0005A\u0011V\r\\'fi\u0006$\u0017\r^1Rk\u0016\u0014\u0018\u0010C\u0004\u00020\u0001!\t%!\r\u0002\u001bM\fG/[:gsR\u0013\u0018-\u001b;t)\u0011\t\u0019$!\u000f\u0011\t\u0019\u000b)DK\u0005\u0004\u0003o9%AB(qi&|g\u000eC\u0004\u0002<\u00055\u0002\u0019A\u0013\u0002!I,\u0017/^5sK\u0012$&/Y5u'\u0016$\bbBA \u0001\u0011\u0005\u0013\u0011I\u0001\u0014iJ\fgn\u001d7bi\u0016$v.\u0012=fG:{G-\u001a\u000b\u0003\u0003\u0007\u0002D!!\u0012\u0002VA1\u0011qIA'\u0003#j!!!\u0013\u000b\u0007\u0005-c!\u0001\u0003fq\u0016\u001c\u0017\u0002BA(\u0003\u0013\u0012\u0001\"\u0012=fG:{G-\u001a\t\u0005\u0003'\n)\u0006\u0004\u0001\u0005\u0019\u0005]\u0013QHA\u0001\u0002\u0003\u0015\t!!\u0017\u0003\u0007}#\u0013'\u0005\u0003\u0002\\\u0005\u0005\u0004c\u0001$\u0002^%\u0019\u0011qL$\u0003\u000f9{G\u000f[5oOB\u0019a)a\u0019\n\u0007\u0005\u0015tIA\u0002B]fDq!!\u001b\u0001\t\u0013\tY'\u0001\nfgRLW.\u0019;f\u001fV$\b/\u001e;TSj,G\u0003BA7\u0003g\u00022ARA8\u0013\r\t\th\u0012\u0002\u0007\t>,(\r\\3\t\u000f\u0005U\u0014q\ra\u0001U\u00059!/\u001a7O_\u0012,\u0007")
public class BatchPhysicalSortMergeJoin
extends BatchPhysicalJoinBase {
    private final RelOptCluster cluster;
    private final RexNode condition;
    private final JoinRelType joinType;
    private final boolean leftSorted;
    private final boolean rightSorted;

    public boolean leftSorted() {
        return this.leftSorted;
    }

    public boolean rightSorted() {
        return this.rightSorted;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isMergeJoinSupportedType(FlinkJoinType joinRelType) {
        FlinkJoinType flinkJoinType = joinRelType;
        FlinkJoinType flinkJoinType2 = FlinkJoinType.INNER;
        if (flinkJoinType == null) {
            if (flinkJoinType2 == null) return true;
        } else if (flinkJoinType.equals(flinkJoinType2)) return true;
        FlinkJoinType flinkJoinType3 = joinRelType;
        FlinkJoinType flinkJoinType4 = FlinkJoinType.LEFT;
        if (flinkJoinType3 == null) {
            if (flinkJoinType4 == null) return true;
        } else if (flinkJoinType3.equals(flinkJoinType4)) return true;
        FlinkJoinType flinkJoinType5 = joinRelType;
        FlinkJoinType flinkJoinType6 = FlinkJoinType.RIGHT;
        if (flinkJoinType5 == null) {
            if (flinkJoinType6 == null) return true;
        } else if (flinkJoinType5.equals(flinkJoinType6)) return true;
        FlinkJoinType flinkJoinType7 = joinRelType;
        FlinkJoinType flinkJoinType8 = FlinkJoinType.FULL;
        if (flinkJoinType7 != null) {
            if (!flinkJoinType7.equals(flinkJoinType8)) return false;
            return true;
        }
        if (flinkJoinType8 == null) return true;
        return false;
    }

    @Override
    public Join copy(RelTraitSet traitSet, RexNode conditionExpr, RelNode left, RelNode right, JoinRelType joinType, boolean semiJoinDone) {
        return new BatchPhysicalSortMergeJoin(this.cluster, traitSet, left, right, conditionExpr, joinType, this.leftSorted(), this.rightSorted());
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).itemIf("leftSorted", BoxesRunTime.boxToBoolean((boolean)this.leftSorted()), this.leftSorted()).itemIf("rightSorted", BoxesRunTime.boxToBoolean((boolean)this.rightSorted()), this.rightSorted());
    }

    @Override
    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        Double leftRowCnt = mq.getRowCount(this.getLeft());
        Double rightRowCnt = mq.getRowCount(this.getRight());
        if (leftRowCnt == null || rightRowCnt == null) {
            return null;
        }
        int numOfSort = this.joinInfo.leftKeys.size();
        double leftSortCpuCost = this.leftSorted() ? Predef$.MODULE$.Double2double(leftRowCnt) : (double)(FlinkCost$.MODULE$.COMPARE_CPU_COST() * numOfSort) * Predef$.MODULE$.Double2double(leftRowCnt) * Math.max(Math.log(Predef$.MODULE$.Double2double(leftRowCnt)), 1.0);
        double rightSortCpuCost = this.rightSorted() ? Predef$.MODULE$.Double2double(rightRowCnt) : (double)(FlinkCost$.MODULE$.COMPARE_CPU_COST() * numOfSort) * Predef$.MODULE$.Double2double(rightRowCnt) * Math.max(Math.log(Predef$.MODULE$.Double2double(rightRowCnt)), 1.0);
        double joinConditionCpuCost = (double)FlinkCost$.MODULE$.COMPARE_CPU_COST() * (Predef$.MODULE$.Double2double(leftRowCnt) + Predef$.MODULE$.Double2double(rightRowCnt));
        double cpuCost = leftSortCpuCost + rightSortCpuCost + joinConditionCpuCost;
        FlinkCostFactory costFactory = (FlinkCostFactory)planner.getCostFactory();
        double sortMemCost = 0.0;
        if (!this.leftSorted()) {
            sortMemCost += Predef$.MODULE$.Double2double(FlinkRelMdUtil$.MODULE$.computeSortMemory(mq, this.getLeft()));
        }
        if (!this.rightSorted()) {
            sortMemCost += Predef$.MODULE$.Double2double(FlinkRelMdUtil$.MODULE$.computeSortMemory(mq, this.getRight()));
        }
        Double rowCount = mq.getRowCount(this);
        return costFactory.makeCost(Predef$.MODULE$.Double2double(rowCount), cpuCost, 0.0, 0.0, sortMemCost);
    }

    @Override
    public Option<RelNode> satisfyTraits(RelTraitSet requiredTraitSet) {
        boolean bl;
        FlinkRelDistribution requiredDistribution = requiredTraitSet.getTrait(FlinkRelDistributionTraitDef$.MODULE$.INSTANCE());
        Tuple3<Object, FlinkRelDistribution, FlinkRelDistribution> tuple3 = this.satisfyHashDistributionOnNonBroadcastJoin(requiredDistribution);
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        boolean canSatisfyDistribution = BoxesRunTime.unboxToBoolean((Object)tuple3._1());
        FlinkRelDistribution leftRequiredDistribution = (FlinkRelDistribution)tuple3._2();
        FlinkRelDistribution rightRequiredDistribution = (FlinkRelDistribution)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)BoxesRunTime.boxToBoolean((boolean)canSatisfyDistribution), (Object)leftRequiredDistribution, (Object)rightRequiredDistribution);
        Tuple3 tuple33 = tuple32;
        boolean canSatisfyDistribution2 = BoxesRunTime.unboxToBoolean((Object)tuple33._1());
        FlinkRelDistribution leftRequiredDistribution2 = (FlinkRelDistribution)tuple33._2();
        FlinkRelDistribution rightRequiredDistribution2 = (FlinkRelDistribution)tuple33._3();
        if (!canSatisfyDistribution2) {
            return None$.MODULE$;
        }
        RelCollation requiredCollation = requiredTraitSet.getTrait(RelCollationTraitDef.INSTANCE);
        List<RelFieldCollation> requiredFieldCollations = requiredCollation.getFieldCollations();
        int shuffleKeysSize = leftRequiredDistribution2.getKeys().size();
        RelNode newLeft = RelOptRule.convert(this.getLeft(), leftRequiredDistribution2);
        RelNode newRight = RelOptRule.convert(this.getRight(), rightRequiredDistribution2);
        if (requiredCollation.getFieldCollations().isEmpty()) {
            bl = false;
        } else if (requiredFieldCollations.size() > shuffleKeysSize) {
            bl = false;
        } else {
            ImmutableIntList leftKeys = leftRequiredDistribution2.getKeys();
            int leftFieldCnt = this.getLeft().getRowType().getFieldCount();
            Buffer rightKeys = (Buffer)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer((List)rightRequiredDistribution2.getKeys()).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)BatchPhysicalSortMergeJoin.$anonfun$satisfyTraits$1(leftFieldCnt, x$2)), Buffer$.MODULE$.canBuildFrom());
            bl = ((IterableLike)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(requiredFieldCollations).zipWithIndex(Buffer$.MODULE$.canBuildFrom())).forall((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)BatchPhysicalSortMergeJoin.$anonfun$satisfyTraits$2(this, leftKeys, leftFieldCnt, rightKeys, x0$1)));
        }
        boolean canProvideCollation = bl;
        RelTraitSet newProvidedTraitSet = this.getTraitSet().replace(requiredDistribution);
        if (canProvideCollation) {
            newProvidedTraitSet = newProvidedTraitSet.replace(requiredCollation);
        }
        return new Some((Object)this.copy(newProvidedTraitSet, JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RelNode[]{newLeft, newRight})))));
    }

    @Override
    public ExecNode<?> translateToExecNode() {
        JoinUtil$.MODULE$.validateJoinSpec(this.joinSpec(), FlinkTypeFactory$.MODULE$.toLogicalRowType(this.left.getRowType()), FlinkTypeFactory$.MODULE$.toLogicalRowType(this.right.getRowType()), JoinUtil$.MODULE$.validateJoinSpec$default$4());
        return new BatchExecSortMergeJoin((ReadableConfig)ShortcutUtils.unwrapTableConfig(this), JoinTypeUtil.getFlinkJoinType(this.joinType), this.joinSpec().getLeftKeys(), this.joinSpec().getRightKeys(), this.joinSpec().getFilterNulls(), this.condition, this.estimateOutputSize(this.getLeft()) < this.estimateOutputSize(this.getRight()), InputProperty.builder().requiredDistribution(InputProperty.hashDistribution(this.joinSpec().getLeftKeys())).damBehavior(InputProperty.DamBehavior.END_INPUT).build(), InputProperty.builder().requiredDistribution(InputProperty.hashDistribution(this.joinSpec().getRightKeys())).damBehavior(InputProperty.DamBehavior.END_INPUT).build(), FlinkTypeFactory$.MODULE$.toLogicalRowType(this.getRowType()), this.getRelDetailedDescription());
    }

    private double estimateOutputSize(RelNode relNode) {
        RelMetadataQuery mq = relNode.getCluster().getMetadataQuery();
        return Predef$.MODULE$.Double2double(mq.getAverageRowSize(relNode)) * Predef$.MODULE$.Double2double(mq.getRowCount(relNode));
    }

    public static final /* synthetic */ int $anonfun$satisfyTraits$1(int leftFieldCnt$1, Integer x$2) {
        return Predef$.MODULE$.Integer2int(x$2) + leftFieldCnt$1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$satisfyTraits$2(BatchPhysicalSortMergeJoin $this, ImmutableIntList leftKeys$1, int leftFieldCnt$1, Buffer rightKeys$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        RelFieldCollation collation = (RelFieldCollation)tuple2._1();
        int index = tuple2._2$mcI$sp();
        int idxOfCollation = collation.getFieldIndex();
        if (idxOfCollation < leftFieldCnt$1) {
            JoinRelType joinRelType = $this.joinType;
            JoinRelType joinRelType2 = JoinRelType.RIGHT;
            if (joinRelType == null ? joinRelType2 != null : !((Object)((Object)joinRelType)).equals((Object)joinRelType2)) {
                RelFieldCollation fieldCollationOnLeftSortKey = FlinkRelOptUtil$.MODULE$.ofRelFieldCollation(Predef$.MODULE$.Integer2int(leftKeys$1.get(index)));
                RelFieldCollation relFieldCollation = collation;
                RelFieldCollation relFieldCollation2 = fieldCollationOnLeftSortKey;
                if (relFieldCollation != null) {
                    if (!((Object)relFieldCollation).equals(relFieldCollation2)) return false;
                    return true;
                }
                if (relFieldCollation2 == null) return true;
                return false;
            }
        }
        if (idxOfCollation < leftFieldCnt$1) return false;
        JoinRelType joinRelType = $this.joinType;
        JoinRelType joinRelType3 = JoinRelType.RIGHT;
        if (joinRelType == null ? joinRelType3 != null : !((Object)((Object)joinRelType)).equals((Object)joinRelType3)) {
            JoinRelType joinRelType4 = $this.joinType;
            JoinRelType joinRelType5 = JoinRelType.INNER;
            if (joinRelType4 == null) {
                if (joinRelType5 != null) {
                    return false;
                }
            } else if (!((Object)((Object)joinRelType4)).equals((Object)joinRelType5)) return false;
        }
        RelFieldCollation fieldCollationOnRightSortKey = FlinkRelOptUtil$.MODULE$.ofRelFieldCollation(BoxesRunTime.unboxToInt(JavaConversions$.MODULE$.deprecated$u0020bufferAsJavaList(rightKeys$1).get(index)));
        RelFieldCollation relFieldCollation = collation;
        RelFieldCollation relFieldCollation3 = fieldCollationOnRightSortKey;
        if (relFieldCollation != null) {
            if (!((Object)relFieldCollation).equals(relFieldCollation3)) return false;
            return true;
        }
        if (relFieldCollation3 == null) return true;
        return false;
    }

    public BatchPhysicalSortMergeJoin(RelOptCluster cluster, RelTraitSet traitSet, RelNode leftRel, RelNode rightRel, RexNode condition, JoinRelType joinType, boolean leftSorted, boolean rightSorted) {
        this.cluster = cluster;
        this.condition = condition;
        this.joinType = joinType;
        this.leftSorted = leftSorted;
        this.rightSorted = rightSorted;
        super(cluster, traitSet, leftRel, rightRel, condition, joinType);
    }
}

