/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.stream;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.time.Duration;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.flink.FlinkVersion;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.core.memory.ManagedMemoryUseCase;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.transformations.OneInputTransformation;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.connector.Projection;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.expressions.FieldReferenceExpression;
import org.apache.flink.table.expressions.ValueLiteralExpression;
import org.apache.flink.table.functions.python.PythonAggregateFunctionInfo;
import org.apache.flink.table.functions.python.PythonFunctionInfo;
import org.apache.flink.table.functions.python.PythonFunctionKind;
import org.apache.flink.table.planner.codegen.CodeGeneratorContext;
import org.apache.flink.table.planner.codegen.ProjectionCodeGenerator;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.plan.logical.LogicalWindow;
import org.apache.flink.table.planner.plan.logical.SessionGroupWindow;
import org.apache.flink.table.planner.plan.logical.SlidingGroupWindow;
import org.apache.flink.table.planner.plan.logical.TumblingGroupWindow;
import org.apache.flink.table.planner.plan.nodes.exec.ExecEdge;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeConfig;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeContext;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeMetadata;
import org.apache.flink.table.planner.plan.nodes.exec.InputProperty;
import org.apache.flink.table.planner.plan.nodes.exec.stream.StreamExecAggregateBase;
import org.apache.flink.table.planner.plan.nodes.exec.utils.CommonPythonUtil;
import org.apache.flink.table.planner.plan.nodes.exec.utils.ExecNodeUtil;
import org.apache.flink.table.planner.plan.utils.AggregateInfoList;
import org.apache.flink.table.planner.plan.utils.AggregateUtil;
import org.apache.flink.table.planner.plan.utils.KeySelectorUtil;
import org.apache.flink.table.planner.plan.utils.PythonUtil;
import org.apache.flink.table.planner.plan.utils.WindowEmitStrategy;
import org.apache.flink.table.planner.utils.JavaScalaConversionUtil;
import org.apache.flink.table.planner.utils.TableConfigUtils;
import org.apache.flink.table.runtime.dataview.DataViewSpec;
import org.apache.flink.table.runtime.generated.GeneratedProjection;
import org.apache.flink.table.runtime.groupwindow.NamedWindowProperty;
import org.apache.flink.table.runtime.keyselector.RowDataKeySelector;
import org.apache.flink.table.runtime.operators.window.groupwindow.assigners.CountSlidingWindowAssigner;
import org.apache.flink.table.runtime.operators.window.groupwindow.assigners.CountTumblingWindowAssigner;
import org.apache.flink.table.runtime.operators.window.groupwindow.assigners.GroupWindowAssigner;
import org.apache.flink.table.runtime.operators.window.groupwindow.assigners.SessionWindowAssigner;
import org.apache.flink.table.runtime.operators.window.groupwindow.assigners.SlidingWindowAssigner;
import org.apache.flink.table.runtime.operators.window.groupwindow.assigners.TumblingWindowAssigner;
import org.apache.flink.table.runtime.operators.window.groupwindow.triggers.ElementTriggers;
import org.apache.flink.table.runtime.operators.window.groupwindow.triggers.EventTimeTriggers;
import org.apache.flink.table.runtime.operators.window.groupwindow.triggers.ProcessingTimeTriggers;
import org.apache.flink.table.runtime.operators.window.groupwindow.triggers.Trigger;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.runtime.util.TimeWindowUtil;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ExecNodeMetadata(name="stream-exec-python-group-window-aggregate", version=1, producedTransformations={"python-group-window-aggregate"}, minPlanVersion=FlinkVersion.v1_16, minStateVersion=FlinkVersion.v1_16)
public class StreamExecPythonGroupWindowAggregate
extends StreamExecAggregateBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(StreamExecPythonGroupWindowAggregate.class);
    public static final String PYTHON_GROUP_WINDOW_AGGREGATE_TRANSFORMATION = "python-group-window-aggregate";
    public static final String FIELD_NAME_WINDOW = "window";
    public static final String FIELD_NAME_NAMED_WINDOW_PROPERTIES = "namedWindowProperties";
    private static final String ARROW_STREAM_PYTHON_GROUP_WINDOW_AGGREGATE_FUNCTION_OPERATOR_NAME = "org.apache.flink.table.runtime.operators.python.aggregate.arrow.stream.StreamArrowPythonGroupWindowAggregateFunctionOperator";
    private static final String GENERAL_STREAM_PYTHON_GROUP_WINDOW_AGGREGATE_FUNCTION_OPERATOR_NAME = "org.apache.flink.table.runtime.operators.python.aggregate.PythonStreamGroupWindowAggregateOperator";
    private static final String GENERAL_STREAM_PYTHON_CREATE_TUMBLING_GROUP_WINDOW_METHOD = "createTumblingGroupWindowAggregateOperator";
    private static final String GENERAL_STREAM_PYTHON_CREATE_SLIDING_GROUP_WINDOW_METHOD = "createSlidingGroupWindowAggregateOperator";
    private static final String GENERAL_STREAM_PYTHON_CREATE_SESSION_GROUP_WINDOW_METHOD = "createSessionGroupWindowAggregateOperator";
    @JsonProperty(value="grouping")
    private final int[] grouping;
    @JsonProperty(value="aggCalls")
    private final AggregateCall[] aggCalls;
    @JsonProperty(value="window")
    private final LogicalWindow window;
    @JsonProperty(value="namedWindowProperties")
    private final NamedWindowProperty[] namedWindowProperties;
    @JsonProperty(value="needRetraction")
    private final boolean needRetraction;
    @JsonProperty(value="generateUpdateBefore")
    private final boolean generateUpdateBefore;

    public StreamExecPythonGroupWindowAggregate(ReadableConfig tableConfig, int[] grouping, AggregateCall[] aggCalls, LogicalWindow window, NamedWindowProperty[] namedWindowProperties, boolean generateUpdateBefore, boolean needRetraction, InputProperty inputProperty, RowType outputType, String description) {
        this(ExecNodeContext.newNodeId(), ExecNodeContext.newContext(StreamExecPythonGroupWindowAggregate.class), ExecNodeContext.newPersistedConfig(StreamExecPythonGroupWindowAggregate.class, tableConfig), grouping, aggCalls, window, namedWindowProperties, generateUpdateBefore, needRetraction, Collections.singletonList(inputProperty), outputType, description);
    }

    @JsonCreator
    public StreamExecPythonGroupWindowAggregate(@JsonProperty(value="id") int id, @JsonProperty(value="type") ExecNodeContext context, @JsonProperty(value="configuration") ReadableConfig persistedConfig, @JsonProperty(value="grouping") int[] grouping, @JsonProperty(value="aggCalls") AggregateCall[] aggCalls, @JsonProperty(value="window") LogicalWindow window, @JsonProperty(value="namedWindowProperties") NamedWindowProperty[] namedWindowProperties, @JsonProperty(value="generateUpdateBefore") boolean generateUpdateBefore, @JsonProperty(value="needRetraction") boolean needRetraction, @JsonProperty(value="inputProperties") List<InputProperty> inputProperties, @JsonProperty(value="outputType") RowType outputType, @JsonProperty(value="description") String description) {
        super(id, context, persistedConfig, inputProperties, (LogicalType)outputType, description);
        Preconditions.checkArgument((inputProperties.size() == 1 ? 1 : 0) != 0);
        this.grouping = (int[])Preconditions.checkNotNull((Object)grouping);
        this.aggCalls = (AggregateCall[])Preconditions.checkNotNull((Object)aggCalls);
        this.window = (LogicalWindow)Preconditions.checkNotNull((Object)window);
        this.namedWindowProperties = (NamedWindowProperty[])Preconditions.checkNotNull((Object)namedWindowProperties);
        this.generateUpdateBefore = generateUpdateBefore;
        this.needRetraction = needRetraction;
    }

    @Override
    protected Transformation<RowData> translateToPlanInternal(PlannerBase planner, ExecNodeConfig config) {
        OneInputTransformation<RowData, RowData> transform;
        int inputTimeFieldIndex;
        boolean isCountWindow = this.window instanceof TumblingGroupWindow ? AggregateUtil.hasRowIntervalType(((TumblingGroupWindow)this.window).size()) : (this.window instanceof SlidingGroupWindow ? AggregateUtil.hasRowIntervalType(((SlidingGroupWindow)this.window).size()) : false);
        if (isCountWindow && this.grouping.length > 0 && config.getStateRetentionTime() < 0L) {
            LOGGER.warn("No state retention interval configured for a query which accumulates state. Please provide a query configuration with valid retention interval to prevent excessive state size. You may specify a retention time of 0 to not clean up the state.");
        }
        ExecEdge inputEdge = this.getInputEdges().get(0);
        Transformation<?> inputTransform = inputEdge.translateToPlan(planner);
        RowType inputRowType = (RowType)inputEdge.getOutputType();
        RowType outputRowType = InternalTypeInfo.of((LogicalType)this.getOutputType()).toRowType();
        if (AggregateUtil.isRowtimeAttribute(this.window.timeAttribute())) {
            inputTimeFieldIndex = this.window.timeAttribute().getFieldIndex();
            if (inputTimeFieldIndex < 0) {
                throw new TableException("Group window must defined on a time attribute, but the time attribute can't be found.\nThis should never happen. Please file an issue.");
            }
        } else {
            inputTimeFieldIndex = -1;
        }
        ZoneId shiftTimeZone = TimeWindowUtil.getShiftTimeZone((LogicalType)this.window.timeAttribute().getOutputDataType().getLogicalType(), (ZoneId)TableConfigUtils.getLocalTimeZone(config));
        Tuple2<GroupWindowAssigner<?>, Trigger<?>> windowAssignerAndTrigger = this.generateWindowAssignerAndTrigger();
        GroupWindowAssigner windowAssigner = (GroupWindowAssigner)windowAssignerAndTrigger.f0;
        Trigger trigger = (Trigger)windowAssignerAndTrigger.f1;
        Configuration pythonConfig = CommonPythonUtil.extractPythonConfiguration(planner.getExecEnv(), config, planner.getFlinkContext().getClassLoader());
        ExecNodeConfig pythonNodeConfig = ExecNodeConfig.ofNodeConfig((ReadableConfig)pythonConfig, config.isCompiled());
        boolean isGeneralPythonUDAF = Arrays.stream(this.aggCalls).anyMatch(x -> PythonUtil.isPythonAggregate(x, PythonFunctionKind.GENERAL));
        WindowEmitStrategy emitStrategy = WindowEmitStrategy.apply(config, this.window);
        if (isGeneralPythonUDAF) {
            boolean[] aggCallNeedRetractions = new boolean[this.aggCalls.length];
            Arrays.fill(aggCallNeedRetractions, this.needRetraction);
            AggregateInfoList aggInfoList = AggregateUtil.transformToStreamAggregateInfoList(planner.getTypeFactory(), inputRowType, JavaScalaConversionUtil.toScala(Arrays.asList(this.aggCalls)), aggCallNeedRetractions, this.needRetraction, true, true);
            transform = this.createGeneralPythonStreamWindowGroupOneInputTransformation(inputTransform, inputRowType, outputRowType, inputTimeFieldIndex, windowAssigner, aggInfoList, emitStrategy.getAllowLateness(), pythonConfig, pythonNodeConfig, planner.getFlinkContext().getClassLoader(), shiftTimeZone);
        } else {
            transform = this.createPandasPythonStreamWindowGroupOneInputTransformation(inputTransform, inputRowType, outputRowType, inputTimeFieldIndex, windowAssigner, trigger, emitStrategy.getAllowLateness(), pythonConfig, pythonNodeConfig, planner.getFlinkContext().getClassLoader(), shiftTimeZone);
        }
        if (CommonPythonUtil.isPythonWorkerUsingManagedMemory(pythonConfig, planner.getFlinkContext().getClassLoader())) {
            transform.declareManagedMemoryUseCaseAtSlotScope(ManagedMemoryUseCase.PYTHON);
        }
        RowDataKeySelector selector = KeySelectorUtil.getRowDataSelector(planner.getFlinkContext().getClassLoader(), this.grouping, (InternalTypeInfo<RowData>)InternalTypeInfo.of((RowType)inputRowType));
        transform.setStateKeySelector((KeySelector)selector);
        transform.setStateKeyType((TypeInformation)selector.getProducedType());
        return transform;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Tuple2<GroupWindowAssigner<?>, Trigger<?>> generateWindowAssignerAndTrigger() {
        ProcessingTimeTriggers.AfterEndOfWindow trigger;
        TumblingWindowAssigner windowAssiger;
        if (this.window instanceof TumblingGroupWindow) {
            TumblingGroupWindow tumblingWindow = (TumblingGroupWindow)this.window;
            FieldReferenceExpression timeField = tumblingWindow.timeField();
            ValueLiteralExpression size = tumblingWindow.size();
            if (AggregateUtil.isProctimeAttribute(timeField) && AggregateUtil.hasTimeIntervalType(size)) {
                windowAssiger = TumblingWindowAssigner.of((Duration)AggregateUtil.toDuration(size)).withProcessingTime();
                trigger = ProcessingTimeTriggers.afterEndOfWindow();
                return Tuple2.of((Object)windowAssiger, (Object)trigger);
            } else if (AggregateUtil.isRowtimeAttribute(timeField) && AggregateUtil.hasTimeIntervalType(size)) {
                windowAssiger = TumblingWindowAssigner.of((Duration)AggregateUtil.toDuration(size)).withEventTime();
                trigger = EventTimeTriggers.afterEndOfWindow();
                return Tuple2.of((Object)windowAssiger, (Object)trigger);
            } else {
                if (!AggregateUtil.isProctimeAttribute(timeField) || !AggregateUtil.hasRowIntervalType(size)) throw new UnsupportedOperationException("Event-time grouping windows on row intervals are currently not supported.");
                windowAssiger = CountTumblingWindowAssigner.of((long)AggregateUtil.toLong(size));
                trigger = ElementTriggers.count((long)AggregateUtil.toLong(size));
            }
            return Tuple2.of((Object)windowAssiger, (Object)trigger);
        } else if (this.window instanceof SlidingGroupWindow) {
            SlidingGroupWindow slidingWindow = (SlidingGroupWindow)this.window;
            FieldReferenceExpression timeField = slidingWindow.timeField();
            ValueLiteralExpression size = slidingWindow.size();
            ValueLiteralExpression slide = slidingWindow.slide();
            if (AggregateUtil.isProctimeAttribute(timeField) && AggregateUtil.hasTimeIntervalType(size)) {
                windowAssiger = SlidingWindowAssigner.of((Duration)AggregateUtil.toDuration(size), (Duration)AggregateUtil.toDuration(slide)).withProcessingTime();
                trigger = ProcessingTimeTriggers.afterEndOfWindow();
                return Tuple2.of((Object)windowAssiger, (Object)trigger);
            } else if (AggregateUtil.isRowtimeAttribute(timeField) && AggregateUtil.hasTimeIntervalType(size)) {
                windowAssiger = SlidingWindowAssigner.of((Duration)AggregateUtil.toDuration(size), (Duration)AggregateUtil.toDuration(slide));
                trigger = EventTimeTriggers.afterEndOfWindow();
                return Tuple2.of((Object)windowAssiger, (Object)trigger);
            } else {
                if (!AggregateUtil.isProctimeAttribute(timeField) || !AggregateUtil.hasRowIntervalType(size)) throw new UnsupportedOperationException("Event-time grouping windows on row intervals are currently not supported.");
                windowAssiger = CountSlidingWindowAssigner.of((long)AggregateUtil.toLong(size), (long)AggregateUtil.toLong(slide));
                trigger = ElementTriggers.count((long)AggregateUtil.toLong(size));
            }
            return Tuple2.of((Object)windowAssiger, (Object)trigger);
        } else {
            if (!(this.window instanceof SessionGroupWindow)) throw new TableException("Unsupported window: " + this.window.toString());
            SessionGroupWindow sessionWindow = (SessionGroupWindow)this.window;
            FieldReferenceExpression timeField = sessionWindow.timeField();
            ValueLiteralExpression gap = sessionWindow.gap();
            if (AggregateUtil.isProctimeAttribute(timeField)) {
                windowAssiger = SessionWindowAssigner.withGap((Duration)AggregateUtil.toDuration(gap));
                trigger = ProcessingTimeTriggers.afterEndOfWindow();
                return Tuple2.of((Object)windowAssiger, (Object)trigger);
            } else {
                if (!AggregateUtil.isRowtimeAttribute(timeField)) throw new UnsupportedOperationException("This should not happen.");
                windowAssiger = SessionWindowAssigner.withGap((Duration)AggregateUtil.toDuration(gap));
                trigger = EventTimeTriggers.afterEndOfWindow();
            }
        }
        return Tuple2.of((Object)windowAssiger, (Object)trigger);
    }

    private OneInputTransformation<RowData, RowData> createPandasPythonStreamWindowGroupOneInputTransformation(Transformation<RowData> inputTransform, RowType inputRowType, RowType outputRowType, int inputTimeFieldIndex, GroupWindowAssigner<?> windowAssigner, Trigger<?> trigger, long allowance, Configuration pythonConfig, ExecNodeConfig config, ClassLoader classLoader, ZoneId shiftTimeZone) {
        Tuple2<int[], PythonFunctionInfo[]> aggInfos = CommonPythonUtil.extractPythonAggregateFunctionInfosFromAggregateCall(this.aggCalls);
        int[] pythonUdafInputOffsets = (int[])aggInfos.f0;
        PythonFunctionInfo[] pythonFunctionInfos = (PythonFunctionInfo[])aggInfos.f1;
        OneInputStreamOperator<RowData, RowData> pythonOperator = this.getPandasPythonStreamGroupWindowAggregateFunctionOperator(config, classLoader, pythonConfig, inputRowType, outputRowType, windowAssigner, trigger, allowance, inputTimeFieldIndex, pythonUdafInputOffsets, pythonFunctionInfos, shiftTimeZone);
        return ExecNodeUtil.createOneInputTransformation(inputTransform, this.createTransformationMeta(PYTHON_GROUP_WINDOW_AGGREGATE_TRANSFORMATION, config), pythonOperator, InternalTypeInfo.of((RowType)outputRowType), inputTransform.getParallelism(), false);
    }

    private OneInputTransformation<RowData, RowData> createGeneralPythonStreamWindowGroupOneInputTransformation(Transformation<RowData> inputTransform, RowType inputRowType, RowType outputRowType, int inputTimeFieldIndex, GroupWindowAssigner<?> windowAssigner, AggregateInfoList aggInfoList, long allowance, Configuration pythonConfig, ExecNodeConfig pythonNodeConfig, ClassLoader classLoader, ZoneId shiftTimeZone) {
        int inputCountIndex = aggInfoList.getIndexOfCountStar();
        boolean countStarInserted = aggInfoList.countStarInserted();
        Tuple2<PythonAggregateFunctionInfo[], DataViewSpec[][]> aggInfosAndDataViewSpecs = CommonPythonUtil.extractPythonAggregateFunctionInfos(aggInfoList, this.aggCalls);
        PythonAggregateFunctionInfo[] pythonFunctionInfos = (PythonAggregateFunctionInfo[])aggInfosAndDataViewSpecs.f0;
        DataViewSpec[][] dataViewSpecs = (DataViewSpec[][])aggInfosAndDataViewSpecs.f1;
        OneInputStreamOperator<RowData, RowData> pythonOperator = this.getGeneralPythonStreamGroupWindowAggregateFunctionOperator(pythonConfig, classLoader, inputRowType, outputRowType, windowAssigner, pythonFunctionInfos, dataViewSpecs, inputTimeFieldIndex, inputCountIndex, this.generateUpdateBefore, countStarInserted, allowance, shiftTimeZone);
        return ExecNodeUtil.createOneInputTransformation(inputTransform, this.createTransformationMeta(PYTHON_GROUP_WINDOW_AGGREGATE_TRANSFORMATION, pythonNodeConfig), pythonOperator, InternalTypeInfo.of((RowType)outputRowType), inputTransform.getParallelism(), false);
    }

    private OneInputStreamOperator<RowData, RowData> getPandasPythonStreamGroupWindowAggregateFunctionOperator(ExecNodeConfig config, ClassLoader classLoader, Configuration pythonConfig, RowType inputRowType, RowType outputRowType, GroupWindowAssigner<?> windowAssigner, Trigger<?> trigger, long allowance, int inputTimeFieldIndex, int[] udafInputOffsets, PythonFunctionInfo[] pythonFunctionInfos, ZoneId shiftTimeZone) {
        Class<?> clazz = CommonPythonUtil.loadClass(ARROW_STREAM_PYTHON_GROUP_WINDOW_AGGREGATE_FUNCTION_OPERATOR_NAME, classLoader);
        RowType userDefinedFunctionInputType = (RowType)Projection.of((int[])udafInputOffsets).project((LogicalType)inputRowType);
        RowType userDefinedFunctionOutputType = (RowType)Projection.range((int)this.grouping.length, (int)(outputRowType.getFieldCount() - this.namedWindowProperties.length)).project((LogicalType)outputRowType);
        try {
            Constructor<?> ctor = clazz.getConstructor(Configuration.class, PythonFunctionInfo[].class, RowType.class, RowType.class, RowType.class, Integer.TYPE, GroupWindowAssigner.class, Trigger.class, Long.TYPE, NamedWindowProperty[].class, ZoneId.class, GeneratedProjection.class);
            return (OneInputStreamOperator)ctor.newInstance(pythonConfig, pythonFunctionInfos, inputRowType, userDefinedFunctionInputType, userDefinedFunctionOutputType, inputTimeFieldIndex, windowAssigner, trigger, allowance, this.namedWindowProperties, shiftTimeZone, ProjectionCodeGenerator.generateProjection(new CodeGeneratorContext(config, classLoader), "UdafInputProjection", inputRowType, userDefinedFunctionInputType, udafInputOffsets));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new TableException("Python StreamArrowPythonGroupWindowAggregateFunctionOperator constructed failed.", (Throwable)e);
        }
    }

    private OneInputStreamOperator<RowData, RowData> getGeneralPythonStreamGroupWindowAggregateFunctionOperator(Configuration config, ClassLoader classLoader, RowType inputType, RowType outputType, GroupWindowAssigner<?> windowAssigner, PythonAggregateFunctionInfo[] aggregateFunctions, DataViewSpec[][] dataViewSpecs, int inputTimeFieldIndex, int indexOfCountStar, boolean generateUpdateBefore, boolean countStarInserted, long allowance, ZoneId shiftTimeZone) {
        Class<?> clazz = CommonPythonUtil.loadClass(GENERAL_STREAM_PYTHON_GROUP_WINDOW_AGGREGATE_FUNCTION_OPERATOR_NAME, classLoader);
        boolean isRowTime = AggregateUtil.isRowtimeAttribute(this.window.timeAttribute());
        try {
            if (this.window instanceof TumblingGroupWindow) {
                ValueLiteralExpression size = ((TumblingGroupWindow)this.window).size();
                Method create = clazz.getMethod(GENERAL_STREAM_PYTHON_CREATE_TUMBLING_GROUP_WINDOW_METHOD, Configuration.class, RowType.class, RowType.class, PythonAggregateFunctionInfo[].class, DataViewSpec[][].class, int[].class, Integer.TYPE, Boolean.TYPE, Boolean.TYPE, Integer.TYPE, GroupWindowAssigner.class, Boolean.TYPE, Boolean.TYPE, Long.TYPE, Long.TYPE, NamedWindowProperty[].class, ZoneId.class);
                return (OneInputStreamOperator)create.invoke(null, new Object[]{config, inputType, outputType, aggregateFunctions, dataViewSpecs, this.grouping, indexOfCountStar, generateUpdateBefore, countStarInserted, inputTimeFieldIndex, windowAssigner, isRowTime, AggregateUtil.hasTimeIntervalType(size), AggregateUtil.toDuration(size).toMillis(), allowance, this.namedWindowProperties, shiftTimeZone});
            }
            if (this.window instanceof SlidingGroupWindow) {
                ValueLiteralExpression size = ((SlidingGroupWindow)this.window).size();
                ValueLiteralExpression slide = ((SlidingGroupWindow)this.window).slide();
                Method create = clazz.getMethod(GENERAL_STREAM_PYTHON_CREATE_SLIDING_GROUP_WINDOW_METHOD, Configuration.class, RowType.class, RowType.class, PythonAggregateFunctionInfo[].class, DataViewSpec[][].class, int[].class, Integer.TYPE, Boolean.TYPE, Boolean.TYPE, Integer.TYPE, GroupWindowAssigner.class, Boolean.TYPE, Boolean.TYPE, Long.TYPE, Long.TYPE, Long.TYPE, NamedWindowProperty[].class, ZoneId.class);
                return (OneInputStreamOperator)create.invoke(null, new Object[]{config, inputType, outputType, aggregateFunctions, dataViewSpecs, this.grouping, indexOfCountStar, generateUpdateBefore, countStarInserted, inputTimeFieldIndex, windowAssigner, isRowTime, AggregateUtil.hasTimeIntervalType(size), AggregateUtil.toDuration(size).toMillis(), AggregateUtil.toDuration(slide).toMillis(), allowance, this.namedWindowProperties, shiftTimeZone});
            }
            if (this.window instanceof SessionGroupWindow) {
                ValueLiteralExpression gap = ((SessionGroupWindow)this.window).gap();
                Method create = clazz.getMethod(GENERAL_STREAM_PYTHON_CREATE_SESSION_GROUP_WINDOW_METHOD, Configuration.class, RowType.class, RowType.class, PythonAggregateFunctionInfo[].class, DataViewSpec[][].class, int[].class, Integer.TYPE, Boolean.TYPE, Boolean.TYPE, Integer.TYPE, GroupWindowAssigner.class, Boolean.TYPE, Long.TYPE, Long.TYPE, NamedWindowProperty[].class, ZoneId.class);
                return (OneInputStreamOperator)create.invoke(null, new Object[]{config, inputType, outputType, aggregateFunctions, dataViewSpecs, this.grouping, indexOfCountStar, generateUpdateBefore, countStarInserted, inputTimeFieldIndex, windowAssigner, isRowTime, AggregateUtil.toDuration(gap).toMillis(), allowance, this.namedWindowProperties, shiftTimeZone});
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new TableException("Python PythonStreamGroupWindowAggregateOperator constructed failed.", (Throwable)e);
        }
        throw new RuntimeException(String.format("Unsupported LogicWindow Type %s", this.window));
    }
}

