/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.serde;

import java.io.IOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonParser;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.DatabindContext;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.DeserializationContext;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.UnresolvedIdentifier;
import org.apache.flink.table.planner.plan.nodes.exec.serde.SerdeContext;

@Internal
final class ObjectIdentifierJsonDeserializer
extends StdDeserializer<ObjectIdentifier> {
    private static final long serialVersionUID = 1L;

    ObjectIdentifierJsonDeserializer() {
        super(ObjectIdentifier.class);
    }

    public ObjectIdentifier deserialize(JsonParser jsonParser, DeserializationContext ctx) throws IOException {
        return ObjectIdentifierJsonDeserializer.deserialize(jsonParser.getValueAsString(), SerdeContext.get((DatabindContext)ctx));
    }

    static ObjectIdentifier deserialize(String identifierStr, SerdeContext ctx) {
        UnresolvedIdentifier unresolvedIdentifier = ctx.getParser().parseIdentifier(identifierStr);
        return ObjectIdentifier.of((String)((String)unresolvedIdentifier.getCatalogName().orElseThrow(() -> ObjectIdentifierJsonDeserializer.incompleteIdentifier(identifierStr, "catalogName"))), (String)((String)unresolvedIdentifier.getDatabaseName().orElseThrow(() -> ObjectIdentifierJsonDeserializer.incompleteIdentifier(identifierStr, "databaseName"))), (String)unresolvedIdentifier.getObjectName());
    }

    static ValidationException incompleteIdentifier(String identifierString, String part) {
        return new ValidationException(String.format("The serialized ObjectIdentifier '%s' is incomplete, as it doesn't contain the '%s' part.", identifierString, part));
    }
}

