/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.batch;

import java.util.Arrays;
import java.util.Collections;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.planner.codegen.CodeGeneratorContext;
import org.apache.flink.table.planner.codegen.agg.batch.SortWindowCodeGenerator;
import org.apache.flink.table.planner.codegen.agg.batch.WindowCodeGenerator;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.plan.logical.LogicalWindow;
import org.apache.flink.table.planner.plan.nodes.exec.ExecEdge;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeBase;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeConfig;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeContext;
import org.apache.flink.table.planner.plan.nodes.exec.InputProperty;
import org.apache.flink.table.planner.plan.nodes.exec.SingleTransformationTranslator;
import org.apache.flink.table.planner.plan.nodes.exec.batch.InputSortedExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.utils.ExecNodeUtil;
import org.apache.flink.table.planner.plan.utils.AggregateInfoList;
import org.apache.flink.table.planner.plan.utils.AggregateUtil;
import org.apache.flink.table.planner.utils.JavaScalaConversionUtil;
import org.apache.flink.table.runtime.generated.GeneratedOperator;
import org.apache.flink.table.runtime.groupwindow.NamedWindowProperty;
import org.apache.flink.table.runtime.operators.CodeGenOperatorFactory;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;

public class BatchExecSortWindowAggregate
extends ExecNodeBase<RowData>
implements InputSortedExecNode<RowData>,
SingleTransformationTranslator<RowData> {
    private final int[] grouping;
    private final int[] auxGrouping;
    private final AggregateCall[] aggCalls;
    private final LogicalWindow window;
    private final int inputTimeFieldIndex;
    private final boolean inputTimeIsDate;
    private final NamedWindowProperty[] namedWindowProperties;
    private final RowType aggInputRowType;
    private final boolean enableAssignPane;
    private final boolean isMerge;
    private final boolean isFinal;

    public BatchExecSortWindowAggregate(ReadableConfig tableConfig, int[] grouping, int[] auxGrouping, AggregateCall[] aggCalls, LogicalWindow window, int inputTimeFieldIndex, boolean inputTimeIsDate, NamedWindowProperty[] namedWindowProperties, RowType aggInputRowType, boolean enableAssignPane, boolean isMerge, boolean isFinal, InputProperty inputProperty, RowType outputType, String description) {
        super(ExecNodeContext.newNodeId(), ExecNodeContext.newContext(BatchExecSortWindowAggregate.class), ExecNodeContext.newPersistedConfig(BatchExecSortWindowAggregate.class, tableConfig), Collections.singletonList(inputProperty), (LogicalType)outputType, description);
        this.grouping = grouping;
        this.auxGrouping = auxGrouping;
        this.aggCalls = aggCalls;
        this.window = window;
        this.inputTimeFieldIndex = inputTimeFieldIndex;
        this.inputTimeIsDate = inputTimeIsDate;
        this.namedWindowProperties = namedWindowProperties;
        this.aggInputRowType = aggInputRowType;
        this.enableAssignPane = enableAssignPane;
        this.isMerge = isMerge;
        this.isFinal = isFinal;
    }

    @Override
    protected Transformation<RowData> translateToPlanInternal(PlannerBase planner, ExecNodeConfig config) {
        ExecEdge inputEdge = this.getInputEdges().get(0);
        Transformation<?> inputTransform = inputEdge.translateToPlan(planner);
        AggregateInfoList aggInfos = AggregateUtil.transformToBatchAggregateInfoList(planner.getTypeFactory(), this.aggInputRowType, JavaScalaConversionUtil.toScala(Arrays.asList(this.aggCalls)), null, null);
        int groupBufferLimitSize = (Integer)config.get(ExecutionConfigOptions.TABLE_EXEC_WINDOW_AGG_BUFFER_SIZE_LIMIT);
        Tuple2<Long, Long> windowSizeAndSlideSize = WindowCodeGenerator.getWindowDef(this.window);
        SortWindowCodeGenerator windowCodeGenerator = new SortWindowCodeGenerator(new CodeGeneratorContext(config, planner.getFlinkContext().getClassLoader()), planner.createRelBuilder(), this.window, this.inputTimeFieldIndex, this.inputTimeIsDate, JavaScalaConversionUtil.toScala(Arrays.asList(this.namedWindowProperties)), aggInfos, (RowType)inputEdge.getOutputType(), (RowType)this.getOutputType(), groupBufferLimitSize, 0L, (Long)windowSizeAndSlideSize.f0, (Long)windowSizeAndSlideSize.f1, this.grouping, this.auxGrouping, this.enableAssignPane, this.isMerge, this.isFinal);
        GeneratedOperator<OneInputStreamOperator<RowData, RowData>> generatedOperator = this.grouping.length == 0 ? windowCodeGenerator.genWithoutKeys() : windowCodeGenerator.genWithKeys();
        return ExecNodeUtil.createOneInputTransformation(inputTransform, this.createTransformationName(config), this.createTransformationDescription(config), new CodeGenOperatorFactory(generatedOperator), InternalTypeInfo.of((LogicalType)this.getOutputType()), inputTransform.getParallelism(), false);
    }
}

