/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions.sql;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperandCountRange;
import org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.type.SqlOperandCountRanges;
import org.apache.calcite.sql.type.SqlOperandMetadata;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.sql.validate.SqlNameMatcher;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.util.Static;
import org.apache.flink.shaded.guava31.com.google.common.collect.ImmutableList;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.utils.LogicalTypeChecks;
import org.apache.flink.util.Preconditions;

public class SqlWindowTableFunction
extends org.apache.calcite.sql.SqlWindowTableFunction {
    protected static final String PARAM_STEP = "STEP";
    protected static final String GAP = "GAP";
    public static final SqlReturnTypeInference ARG0_TABLE_FUNCTION_WINDOWING = SqlWindowTableFunction::inferRowType;

    public SqlWindowTableFunction(String name, SqlOperandMetadata operandMetadata) {
        super(name, operandMetadata);
    }

    @Override
    public SqlOperandMetadata getOperandTypeChecker() {
        return super.getOperandTypeChecker();
    }

    @Override
    public SqlReturnTypeInference getRowTypeInference() {
        return ARG0_TABLE_FUNCTION_WINDOWING;
    }

    @Override
    public boolean argumentMustBeScalar(int ordinal) {
        return ordinal != 0;
    }

    private static RelDataType inferRowType(SqlOperatorBinding opBinding) {
        RelDataType timeAttributeType;
        RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
        RelDataType inputRowType = opBinding.getOperandType(0);
        RelDataType descriptorType = opBinding.getOperandType(1);
        RelDataTypeField timeField = descriptorType.getFieldList().get(0);
        if (timeField.getType().getSqlTypeName() == SqlTypeName.NULL) {
            RelDataTypeField field = inputRowType.getField(timeField.getName(), false, false);
            if (field == null) {
                throw new IllegalArgumentException(String.format("Can't find the time attribute field '%s' in the input schema %s.", timeField.getName(), inputRowType.getFullTypeString()));
            }
            timeAttributeType = field.getType();
        } else {
            timeAttributeType = timeField.getType();
        }
        return SqlWindowTableFunction.inferRowType(typeFactory, inputRowType, timeAttributeType);
    }

    public static RelDataType inferRowType(RelDataTypeFactory typeFactory, RelDataType inputRowType, RelDataType timeAttributeType) {
        return ((RelDataTypeFactory.FieldInfoBuilder)typeFactory.builder().kind(inputRowType.getStructKind()).addAll(inputRowType.getFieldList())).add("window_start", SqlTypeName.TIMESTAMP, 3).add("window_end", SqlTypeName.TIMESTAMP, 3).add("window_time", typeFactory.createTypeWithNullability(timeAttributeType, false)).build();
    }

    protected static abstract class AbstractOperandMetadata
    implements SqlOperandMetadata {
        final List<String> paramNames;
        final int mandatoryParamCount;

        AbstractOperandMetadata(List<String> paramNames, int mandatoryParamCount) {
            this.paramNames = ImmutableList.copyOf(paramNames);
            this.mandatoryParamCount = mandatoryParamCount;
            Preconditions.checkArgument((mandatoryParamCount >= 0 && mandatoryParamCount <= paramNames.size() ? 1 : 0) != 0);
        }

        @Override
        public SqlOperandCountRange getOperandCountRange() {
            return SqlOperandCountRanges.between(this.mandatoryParamCount, this.paramNames.size());
        }

        @Override
        public List<RelDataType> paramTypes(RelDataTypeFactory typeFactory) {
            return Collections.nCopies(this.paramNames.size(), typeFactory.createSqlType(SqlTypeName.ANY));
        }

        @Override
        public List<String> paramNames() {
            return this.paramNames;
        }

        @Override
        public SqlOperandTypeChecker.Consistency getConsistency() {
            return SqlOperandTypeChecker.Consistency.NONE;
        }

        @Override
        public boolean isOptional(int i) {
            return i > this.getOperandCountRange().getMin() && i <= this.getOperandCountRange().getMax();
        }

        boolean throwValidationSignatureErrorOrReturnFalse(SqlCallBinding callBinding, boolean throwOnFailure) {
            if (throwOnFailure) {
                throw callBinding.newValidationSignatureError();
            }
            return false;
        }

        boolean throwExceptionOrReturnFalse(Optional<RuntimeException> e, boolean throwOnFailure) {
            if (e.isPresent()) {
                if (throwOnFailure) {
                    throw e.get();
                }
                return false;
            }
            return true;
        }

        boolean checkTableAndDescriptorOperands(SqlCallBinding callBinding, int descriptorCount) {
            SqlNode operand0 = callBinding.operand(0);
            SqlValidator validator = callBinding.getValidator();
            RelDataType type = validator.getValidatedNodeType(operand0);
            if (type.getSqlTypeName() != SqlTypeName.ROW) {
                return false;
            }
            for (int i = 1; i < descriptorCount + 1; ++i) {
                SqlNode operand = callBinding.operand(i);
                if (operand.getKind() != SqlKind.DESCRIPTOR) {
                    return false;
                }
                this.validateColumnNames(validator, type.getFieldNames(), ((SqlCall)operand).getOperandList());
            }
            return true;
        }

        Optional<RuntimeException> checkTimeColumnDescriptorOperand(SqlCallBinding callBinding, int pos) {
            SqlValidator validator = callBinding.getValidator();
            SqlNode operand0 = callBinding.operand(0);
            RelDataType type = validator.getValidatedNodeType(operand0);
            List<SqlNode> operands = ((SqlCall)callBinding.operand(pos)).getOperandList();
            SqlIdentifier identifier = (SqlIdentifier)operands.get(0);
            String columnName = identifier.getSimple();
            SqlNameMatcher matcher = validator.getCatalogReader().nameMatcher();
            for (RelDataTypeField field : type.getFieldList()) {
                if (!matcher.matches(field.getName(), columnName)) continue;
                RelDataType fieldType = field.getType();
                if (FlinkTypeFactory.isTimeIndicatorType(fieldType)) {
                    return Optional.empty();
                }
                LogicalType timeAttributeType = FlinkTypeFactory.toLogicalType(fieldType);
                if (!LogicalTypeChecks.canBeTimeAttributeType((LogicalType)timeAttributeType)) {
                    ValidationException exception = new ValidationException(String.format("The window function %s requires the timecol to be TIMESTAMP or TIMESTAMP_LTZ, but is %s.\nBesides, the timecol must be a time attribute type in streaming mode.", callBinding.getOperator().getAllowedSignatures(), field.getType()));
                    return Optional.of(exception);
                }
                return Optional.empty();
            }
            IllegalArgumentException error = new IllegalArgumentException(String.format("Can't find the time attribute field '%s' in the input schema %s.", columnName, type.getFullTypeString()));
            return Optional.of(error);
        }

        boolean checkIntervalOperands(SqlCallBinding callBinding, int startPos) {
            SqlValidator validator = callBinding.getValidator();
            for (int i = startPos; i < callBinding.getOperandCount(); ++i) {
                RelDataType type = validator.getValidatedNodeType(callBinding.operand(i));
                if (SqlTypeUtil.isInterval(type)) continue;
                return false;
            }
            return true;
        }

        void validateColumnNames(SqlValidator validator, List<String> fieldNames, List<SqlNode> columnNames) {
            SqlNameMatcher matcher = validator.getCatalogReader().nameMatcher();
            for (SqlNode columnName : columnNames) {
                String name = ((SqlIdentifier)columnName).getSimple();
                if (matcher.indexOf(fieldNames, name) >= 0) continue;
                throw SqlUtil.newContextException(columnName.getParserPosition(), Static.RESOURCE.unknownIdentifier(name));
            }
        }
    }
}

