/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions.casting;

import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.binary.BinaryStringDataUtil;
import org.apache.flink.table.planner.codegen.calls.BuiltInMethods;
import org.apache.flink.table.planner.functions.casting.AbstractExpressionCodeGeneratorCastRule;
import org.apache.flink.table.planner.functions.casting.CastRulePredicate;
import org.apache.flink.table.planner.functions.casting.CastRuleUtils;
import org.apache.flink.table.planner.functions.casting.CodeGeneratorCastRule;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.VarCharType;

class BooleanToStringCastRule
extends AbstractExpressionCodeGeneratorCastRule<Boolean, StringData> {
    static final BooleanToStringCastRule INSTANCE = new BooleanToStringCastRule();

    private BooleanToStringCastRule() {
        super(CastRulePredicate.builder().input(LogicalTypeRoot.BOOLEAN).target((LogicalType)VarCharType.STRING_TYPE).build());
    }

    @Override
    public String generateExpression(CodeGeneratorCastRule.Context context, String inputTerm, LogicalType inputLogicalType, LogicalType targetLogicalType) {
        if (context.legacyBehaviour()) {
            return CastRuleUtils.staticCall(BuiltInMethods.BINARY_STRING_DATA_FROM_STRING(), CastRuleUtils.stringConcat("\"\"", inputTerm));
        }
        return CastRuleUtils.ternaryOperator(inputTerm, CastRuleUtils.accessStaticField(BinaryStringDataUtil.class, "TRUE_STRING"), CastRuleUtils.accessStaticField(BinaryStringDataUtil.class, "FALSE_STRING"));
    }
}

