/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions.aggfunctions;

import java.math.BigDecimal;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.expressions.ApiExpressionUtils;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.UnresolvedCallExpression;
import org.apache.flink.table.expressions.UnresolvedReferenceExpression;
import org.apache.flink.table.functions.DeclarativeAggregateFunction;
import org.apache.flink.table.planner.expressions.ExpressionBuilder;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.utils.LogicalTypeMerging;

public abstract class Sum0AggFunction
extends DeclarativeAggregateFunction {
    private final UnresolvedReferenceExpression sum0 = ApiExpressionUtils.unresolvedRef((String)"sum");

    public int operandCount() {
        return 1;
    }

    public UnresolvedReferenceExpression[] aggBufferAttributes() {
        return new UnresolvedReferenceExpression[]{this.sum0};
    }

    public DataType[] getAggBufferTypes() {
        return new DataType[]{this.getResultType()};
    }

    public Expression[] accumulateExpressions() {
        return new Expression[]{this.adjustSumType(ExpressionBuilder.ifThenElse((Expression)ExpressionBuilder.isNull((Expression)this.operand(0)), (Expression)this.sum0, (Expression)this.adjustedPlus(this.sum0, this.operand(0))))};
    }

    public Expression[] retractExpressions() {
        return new Expression[]{this.adjustSumType(ExpressionBuilder.ifThenElse((Expression)ExpressionBuilder.isNull((Expression)this.operand(0)), (Expression)this.sum0, (Expression)this.adjustedMinus(this.sum0, this.operand(0))))};
    }

    public Expression[] mergeExpressions() {
        return new Expression[]{this.adjustSumType(this.adjustedPlus(this.sum0, this.mergeOperand(this.sum0)))};
    }

    private UnresolvedCallExpression adjustSumType(UnresolvedCallExpression sumExpr) {
        return ExpressionBuilder.cast((Expression)sumExpr, (Expression)ExpressionBuilder.typeLiteral(this.getResultType()));
    }

    public Expression getValueExpression() {
        return this.sum0;
    }

    protected UnresolvedCallExpression adjustedPlus(UnresolvedReferenceExpression arg1, UnresolvedReferenceExpression arg2) {
        return ExpressionBuilder.plus((Expression)arg1, (Expression)arg2);
    }

    protected UnresolvedCallExpression adjustedMinus(UnresolvedReferenceExpression arg1, UnresolvedReferenceExpression arg2) {
        return ExpressionBuilder.minus((Expression)arg1, (Expression)arg2);
    }

    public static class DecimalSum0AggFunction
    extends Sum0AggFunction {
        private final DataType returnType;

        public DecimalSum0AggFunction(DecimalType decimalType) {
            DecimalType sumType = (DecimalType)LogicalTypeMerging.findSumAggType((LogicalType)decimalType);
            this.returnType = DataTypes.DECIMAL((int)sumType.getPrecision(), (int)sumType.getScale());
        }

        public DataType getResultType() {
            return this.returnType;
        }

        public Expression[] initialValuesExpressions() {
            return new Expression[]{ExpressionBuilder.literal(new BigDecimal(0), (DataType)this.getResultType().notNull())};
        }

        @Override
        protected UnresolvedCallExpression adjustedPlus(UnresolvedReferenceExpression arg1, UnresolvedReferenceExpression arg2) {
            return ExpressionBuilder.aggDecimalPlus((Expression)arg1, (Expression)arg2);
        }

        @Override
        protected UnresolvedCallExpression adjustedMinus(UnresolvedReferenceExpression arg1, UnresolvedReferenceExpression arg2) {
            return ExpressionBuilder.aggDecimalMinus((Expression)arg1, (Expression)arg2);
        }
    }

    public static class DoubleSum0AggFunction
    extends Sum0AggFunction {
        public DataType getResultType() {
            return DataTypes.DOUBLE();
        }

        public Expression[] initialValuesExpressions() {
            return new Expression[]{ExpressionBuilder.literal(0.0, (DataType)this.getResultType().notNull())};
        }
    }

    public static class FloatSum0AggFunction
    extends Sum0AggFunction {
        public DataType getResultType() {
            return DataTypes.FLOAT();
        }

        public Expression[] initialValuesExpressions() {
            return new Expression[]{ExpressionBuilder.literal(Float.valueOf(0.0f), (DataType)this.getResultType().notNull())};
        }
    }

    public static class LongSum0AggFunction
    extends Sum0AggFunction {
        public DataType getResultType() {
            return DataTypes.BIGINT();
        }

        public Expression[] initialValuesExpressions() {
            return new Expression[]{ExpressionBuilder.literal(0L, (DataType)this.getResultType().notNull())};
        }
    }

    public static class ShortSum0AggFunction
    extends Sum0AggFunction {
        public DataType getResultType() {
            return DataTypes.SMALLINT();
        }

        public Expression[] initialValuesExpressions() {
            return new Expression[]{ExpressionBuilder.literal((short)0, (DataType)this.getResultType().notNull())};
        }
    }

    public static class ByteSum0AggFunction
    extends Sum0AggFunction {
        public DataType getResultType() {
            return DataTypes.TINYINT();
        }

        public Expression[] initialValuesExpressions() {
            return new Expression[]{ExpressionBuilder.literal((byte)0, (DataType)this.getResultType().notNull())};
        }
    }

    public static class IntSum0AggFunction
    extends Sum0AggFunction {
        public DataType getResultType() {
            return DataTypes.INT();
        }

        public Expression[] initialValuesExpressions() {
            return new Expression[]{ExpressionBuilder.literal(0, (DataType)this.getResultType().notNull())};
        }
    }
}

