/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql;

import java.util.List;
import java.util.Objects;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.util.ImmutableNullableList;
import org.apache.flink.calcite.shaded.org.checkerframework.checker.nullness.qual.Nullable;

public class SqlDescribeTable
extends SqlCall {
    public static final SqlSpecialOperator OPERATOR = new SqlSpecialOperator("DESCRIBE_TABLE", SqlKind.DESCRIBE_TABLE){

        @Override
        public SqlCall createCall(@Nullable SqlLiteral functionQualifier, SqlParserPos pos, SqlNode ... operands) {
            return new SqlDescribeTable(pos, (SqlIdentifier)operands[0], (SqlIdentifier)operands[1]);
        }
    };
    SqlIdentifier table;
    @Nullable SqlIdentifier column;

    public SqlDescribeTable(SqlParserPos pos, SqlIdentifier table, @Nullable SqlIdentifier column) {
        super(pos);
        this.table = Objects.requireNonNull(table, "table");
        this.column = column;
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword("DESCRIBE");
        writer.keyword("TABLE");
        this.table.unparse(writer, leftPrec, rightPrec);
        if (this.column != null) {
            this.column.unparse(writer, leftPrec, rightPrec);
        }
    }

    @Override
    public void setOperand(int i, @Nullable SqlNode operand) {
        switch (i) {
            case 0: {
                this.table = (SqlIdentifier)operand;
                break;
            }
            case 1: {
                this.column = (SqlIdentifier)operand;
                break;
            }
            default: {
                throw new AssertionError(i);
            }
        }
    }

    @Override
    public SqlOperator getOperator() {
        return OPERATOR;
    }

    @Override
    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of(this.table, this.column);
    }

    public SqlIdentifier getTable() {
        return this.table;
    }

    public @Nullable SqlIdentifier getColumn() {
        return this.column;
    }
}

