/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.mutable;

import java.util.List;
import java.util.Objects;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.mutable.MutableRel;
import org.apache.calcite.rel.mutable.MutableRelType;
import org.apache.calcite.rel.mutable.MutableSingleRel;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.apache.calcite.util.Litmus;
import org.apache.calcite.util.Pair;
import org.apache.flink.calcite.shaded.org.checkerframework.checker.nullness.qual.Nullable;

public class MutableProject
extends MutableSingleRel {
    public final List<RexNode> projects;

    private MutableProject(RelDataType rowType, MutableRel input, List<RexNode> projects) {
        super(MutableRelType.PROJECT, rowType, input);
        this.projects = projects;
        assert (RexUtil.compatibleTypes(projects, rowType, Litmus.THROW));
    }

    public static MutableProject of(RelDataType rowType, MutableRel input, List<RexNode> projects) {
        return new MutableProject(rowType, input, projects);
    }

    public static MutableRel of(MutableRel input, List<RexNode> exprList, List<String> fieldNameList) {
        RelDataType rowType = RexUtil.createStructType(input.cluster.getTypeFactory(), exprList, fieldNameList, SqlValidatorUtil.F_SUGGESTER);
        return MutableProject.of(rowType, input, exprList);
    }

    public boolean equals(@Nullable Object obj) {
        return obj == this || obj instanceof MutableProject && MutableRel.PAIRWISE_STRING_EQUIVALENCE.equivalent(this.projects, ((MutableProject)obj).projects) && this.input.equals(((MutableProject)obj).input);
    }

    public int hashCode() {
        return Objects.hash(this.input, MutableRel.PAIRWISE_STRING_EQUIVALENCE.hash(this.projects));
    }

    @Override
    public StringBuilder digest(StringBuilder buf) {
        return buf.append("Project(projects: ").append(this.projects).append(")");
    }

    public final List<Pair<RexNode, String>> getNamedProjects() {
        return Pair.zip(this.projects, this.rowType.getFieldNames());
    }

    public  @Nullable Mappings.TargetMapping getMapping() {
        return Project.getMapping(this.input.rowType.getFieldCount(), this.projects);
    }

    @Override
    public MutableRel clone() {
        return MutableProject.of(this.rowType, this.input.clone(), this.projects);
    }
}

