/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.logical;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollationTraitDef;
import org.apache.calcite.rel.RelDistributionTraitDef;
import org.apache.calcite.rel.RelInput;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelShuttle;
import org.apache.calcite.rel.core.Values;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.rel.metadata.RelMdCollation;
import org.apache.calcite.rel.metadata.RelMdDistribution;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableList;

public class LogicalValues
extends Values {
    public LogicalValues(RelOptCluster cluster, RelTraitSet traitSet, List<RelHint> hints, RelDataType rowType, ImmutableList<ImmutableList<RexLiteral>> tuples) {
        super(cluster, hints, rowType, tuples, traitSet);
    }

    public LogicalValues(RelOptCluster cluster, RelTraitSet traitSet, RelDataType rowType, ImmutableList<ImmutableList<RexLiteral>> tuples) {
        this(cluster, traitSet, Collections.emptyList(), rowType, tuples);
    }

    @Deprecated
    public LogicalValues(RelOptCluster cluster, RelDataType rowType, ImmutableList<ImmutableList<RexLiteral>> tuples) {
        this(cluster, cluster.traitSetOf((RelTrait)Convention.NONE), rowType, tuples);
    }

    public LogicalValues(RelInput input) {
        super(input);
    }

    public static LogicalValues create(RelOptCluster cluster, RelDataType rowType, ImmutableList<ImmutableList<RexLiteral>> tuples) {
        RelMetadataQuery mq = cluster.getMetadataQuery();
        RelTraitSet traitSet = cluster.traitSetOf((RelTrait)Convention.NONE).replaceIfs(RelCollationTraitDef.INSTANCE, () -> RelMdCollation.values(mq, rowType, tuples)).replaceIf(RelDistributionTraitDef.INSTANCE, () -> RelMdDistribution.values(rowType, tuples));
        return new LogicalValues(cluster, traitSet, rowType, tuples);
    }

    @Override
    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        assert (traitSet.containsIfApplicable(Convention.NONE));
        assert (inputs.isEmpty());
        return new LogicalValues(this.getCluster(), traitSet, this.getRowType(), this.tuples);
    }

    public static LogicalValues createEmpty(RelOptCluster cluster, RelDataType rowType) {
        return LogicalValues.create(cluster, rowType, ImmutableList.of());
    }

    public static LogicalValues createOneRow(RelOptCluster cluster) {
        RelDataType rowType = cluster.getTypeFactory().builder().add("ZERO", SqlTypeName.INTEGER).nullable(false).build();
        ImmutableList<ImmutableList<RexLiteral>> tuples = ImmutableList.of(ImmutableList.of(cluster.getRexBuilder().makeExactLiteral(BigDecimal.ZERO, rowType.getFieldList().get(0).getType())));
        return LogicalValues.create(cluster, rowType, tuples);
    }

    @Override
    public RelNode accept(RelShuttle shuttle) {
        return shuttle.visit(this);
    }

    @Override
    public RelNode withHints(List<RelHint> hintList) {
        return new LogicalValues(this.getCluster(), this.traitSet, hintList, this.getRowType(), this.tuples);
    }
}

