/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.window.groupwindow.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.generated.NamespaceAggsHandleFunctionBase;
import org.apache.flink.table.runtime.operators.window.Window;
import org.apache.flink.table.runtime.operators.window.groupwindow.assigners.PanedWindowAssigner;
import org.apache.flink.table.runtime.operators.window.groupwindow.internal.InternalWindowProcessFunction;

public class PanedWindowProcessFunction<K, W extends Window>
extends InternalWindowProcessFunction<K, W> {
    private static final long serialVersionUID = 4259335376102569987L;
    private final PanedWindowAssigner<W> windowAssigner;

    public PanedWindowProcessFunction(PanedWindowAssigner<W> windowAssigner, NamespaceAggsHandleFunctionBase<W> windowAggregator, long allowedLateness) {
        super(windowAssigner, windowAggregator, allowedLateness);
        this.windowAssigner = windowAssigner;
    }

    @Override
    public Collection<W> assignActualWindows(RowData inputRow, long timestamp) throws Exception {
        Collection elementWindows = this.windowAssigner.assignWindows(inputRow, timestamp);
        ArrayList<Window> actualWindows = new ArrayList<Window>(elementWindows.size());
        for (Window window : elementWindows) {
            if (this.isWindowLate(window)) continue;
            actualWindows.add(window);
        }
        return actualWindows;
    }

    @Override
    public Collection<W> assignStateNamespace(RowData inputRow, long timestamp) throws Exception {
        W pane = this.windowAssigner.assignPane(inputRow, timestamp);
        if (!this.isPaneLate(pane)) {
            return Collections.singleton(pane);
        }
        return Collections.emptyList();
    }

    @Override
    public void prepareAggregateAccumulatorForEmit(W window) throws Exception {
        Iterable<W> panes = this.windowAssigner.splitIntoPanes(window);
        RowData acc = this.windowAggregator.createAccumulators();
        this.windowAggregator.setAccumulators(null, acc);
        for (Window pane : panes) {
            RowData paneAcc = this.ctx.getWindowAccumulators(pane);
            if (paneAcc == null) continue;
            this.windowAggregator.merge(pane, paneAcc);
        }
    }

    @Override
    public void cleanWindowIfNeeded(W window, long currentTime) throws Exception {
        if (this.isCleanupTime(window, currentTime)) {
            Iterable<W> panes = this.windowAssigner.splitIntoPanes(window);
            for (Window pane : panes) {
                Window lastWindow = this.windowAssigner.getLastWindow(pane);
                if (!((Window)window).equals(lastWindow)) continue;
                this.ctx.clearWindowState(pane);
            }
            this.ctx.clearTrigger(window);
            this.ctx.clearPreviousState(window);
        }
    }

    private boolean isPaneLate(W pane) {
        return this.windowAssigner.isEventTime() && this.isWindowLate(this.windowAssigner.getLastWindow(pane));
    }
}

