/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.api.runtime;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.operators.ProcessingTimeService;
import org.apache.flink.streaming.runtime.tasks.TimerService;
import org.apache.flink.util.clock.Clock;
import org.apache.flink.util.clock.SystemClock;
import org.apache.flink.util.concurrent.NeverCompleteFuture;

@Internal
public final class NeverFireProcessingTimeService
implements TimerService {
    private static final NeverCompleteFuture FUTURE = new NeverCompleteFuture(Long.MAX_VALUE);
    private AtomicBoolean shutdown = new AtomicBoolean(true);

    public Clock getClock() {
        return SystemClock.getInstance();
    }

    public ScheduledFuture<?> registerTimer(long timestamp, ProcessingTimeService.ProcessingTimeCallback target) {
        return FUTURE;
    }

    public ScheduledFuture<?> scheduleAtFixedRate(ProcessingTimeService.ProcessingTimeCallback callback, long initialDelay, long period) {
        return FUTURE;
    }

    public ScheduledFuture<?> scheduleWithFixedDelay(ProcessingTimeService.ProcessingTimeCallback callback, long initialDelay, long period) {
        return FUTURE;
    }

    public boolean isTerminated() {
        return this.shutdown.get();
    }

    public CompletableFuture<Void> quiesce() {
        this.shutdown.set(true);
        return CompletableFuture.completedFuture(null);
    }

    public void shutdownService() {
        this.shutdown.set(true);
    }

    public boolean shutdownServiceUninterruptible(long timeoutMs) {
        this.shutdown.set(true);
        return this.shutdown.get();
    }
}

