/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.api.input;

import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.StateChangelogOptions;
import org.apache.flink.core.fs.CloseableRegistry;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.runtime.checkpoint.OperatorState;
import org.apache.flink.runtime.execution.Environment;
import org.apache.flink.runtime.state.StateBackend;
import org.apache.flink.runtime.state.StateBackendLoader;
import org.apache.flink.state.api.input.splits.PrioritizedOperatorSubtaskStateInputSplit;
import org.apache.flink.state.api.runtime.NeverFireProcessingTimeService;
import org.apache.flink.state.api.runtime.SavepointEnvironment;
import org.apache.flink.streaming.api.operators.KeyContext;
import org.apache.flink.streaming.api.operators.StreamOperatorStateContext;
import org.apache.flink.streaming.api.operators.StreamTaskStateInitializerImpl;
import org.apache.flink.streaming.runtime.tasks.ProcessingTimeService;
import org.apache.flink.util.DynamicCodeLoadingException;
import org.slf4j.Logger;

@Internal
class StreamOperatorContextBuilder {
    private final RuntimeContext ctx;
    private final ExecutionConfig executionConfig;
    private final Configuration configuration;
    private final OperatorState operatorState;
    private int maxParallelism;
    private final PrioritizedOperatorSubtaskStateInputSplit split;
    private final CloseableRegistry registry;
    @Nullable
    private final StateBackend applicationStateBackend;
    private KeyContext keyContext = new VoidKeyContext();
    @Nullable
    private TypeSerializer<?> keySerializer;

    StreamOperatorContextBuilder(RuntimeContext ctx, Configuration configuration, OperatorState operatorState, PrioritizedOperatorSubtaskStateInputSplit split, CloseableRegistry registry, @Nullable StateBackend applicationStateBackend, ExecutionConfig executionConfig) {
        this.ctx = ctx;
        this.maxParallelism = ctx.getTaskInfo().getMaxNumberOfParallelSubtasks();
        this.configuration = configuration;
        this.operatorState = operatorState;
        this.split = split;
        this.registry = registry;
        this.applicationStateBackend = applicationStateBackend;
        this.executionConfig = executionConfig;
    }

    StreamOperatorContextBuilder withMaxParallelism(int maxParallelism) {
        this.maxParallelism = maxParallelism;
        return this;
    }

    StreamOperatorContextBuilder withKey(KeyContext keyContext, TypeSerializer<?> keySerializer) {
        this.keyContext = keyContext;
        this.keySerializer = keySerializer;
        return this;
    }

    StreamOperatorStateContext build(Logger logger) throws IOException {
        StateBackend stateBackend;
        SavepointEnvironment environment = new SavepointEnvironment.Builder(this.ctx, this.executionConfig, this.maxParallelism).setConfiguration(this.configuration).setSubtaskIndex(this.split.getSplitNumber()).setPrioritizedOperatorSubtaskState(this.split.getPrioritizedOperatorSubtaskState()).build();
        try {
            Configuration jobConfig = environment.getJobConfiguration();
            jobConfig.set(StateChangelogOptions.ENABLE_STATE_CHANGE_LOG, (Object)false);
            Configuration clusterConfig = new Configuration(this.configuration);
            stateBackend = StateBackendLoader.fromApplicationOrConfigOrDefault((StateBackend)this.applicationStateBackend, (Configuration)jobConfig, (Configuration)clusterConfig, (ClassLoader)this.ctx.getUserCodeClassLoader(), (Logger)logger);
        }
        catch (DynamicCodeLoadingException e) {
            throw new IOException("Failed to load state backend", e);
        }
        StreamTaskStateInitializerImpl initializer = new StreamTaskStateInitializerImpl((Environment)environment, stateBackend);
        try {
            return initializer.streamOperatorStateContext(this.operatorState.getOperatorID(), this.operatorState.getOperatorID().toString(), (ProcessingTimeService)new NeverFireProcessingTimeService(), this.keyContext, this.keySerializer, this.registry, (MetricGroup)this.ctx.getMetricGroup(), 1.0, false);
        }
        catch (Exception e) {
            throw new IOException("Failed to restore state backend", e);
        }
    }

    private static class VoidKeyContext
    implements KeyContext {
        private VoidKeyContext() {
        }

        public void setCurrentKey(Object key) {
        }

        public Object getCurrentKey() {
            return null;
        }
    }
}

