/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.api;

import java.util.List;
import javax.annotation.Nullable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.common.functions.GroupReduceFunction;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.operators.FlatMapOperator;
import org.apache.flink.api.java.operators.GroupReduceOperator;
import org.apache.flink.api.java.operators.Operator;
import org.apache.flink.api.java.operators.UnionOperator;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.checkpoint.OperatorState;
import org.apache.flink.runtime.state.StateBackend;
import org.apache.flink.state.api.BootstrapTransformation;
import org.apache.flink.state.api.output.FileCopyFunction;
import org.apache.flink.state.api.output.MergeOperatorStates;
import org.apache.flink.state.api.output.SavepointOutputFormat;
import org.apache.flink.state.api.output.StatePathExtractor;
import org.apache.flink.state.api.runtime.BootstrapTransformationWithID;
import org.apache.flink.state.api.runtime.metadata.SavepointMetadata;
import org.apache.flink.util.Preconditions;

@Deprecated
@PublicEvolving
public abstract class WritableSavepoint<F extends WritableSavepoint> {
    protected final SavepointMetadata metadata;
    @Nullable
    protected final StateBackend stateBackend;
    private final Configuration configuration;

    WritableSavepoint(SavepointMetadata metadata, @Nullable StateBackend stateBackend) {
        Preconditions.checkNotNull((Object)metadata, (String)"The savepoint metadata must not be null");
        this.metadata = metadata;
        this.stateBackend = stateBackend;
        this.configuration = new Configuration();
    }

    public F removeOperator(String uid) {
        this.metadata.removeOperator(uid);
        return (F)this;
    }

    public <T> F withOperator(String uid, BootstrapTransformation<T> transformation) {
        this.metadata.addOperator(uid, transformation);
        return (F)this;
    }

    public <T> F withConfiguration(ConfigOption<T> option, T value) {
        this.configuration.set(option, value);
        return (F)this;
    }

    public final void write(String path) {
        UnionOperator finalOperatorStates;
        Path savepointPath = new Path(path);
        List<BootstrapTransformationWithID<?>> newOperatorTransformations = this.metadata.getNewOperators();
        UnionOperator newOperatorStates = this.writeOperatorStates(newOperatorTransformations, this.configuration, savepointPath);
        List<OperatorState> existingOperators = this.metadata.getExistingOperators();
        if (existingOperators.isEmpty()) {
            finalOperatorStates = newOperatorStates;
        } else {
            Operator existingOperatorStates = newOperatorStates.getExecutionEnvironment().fromCollection(existingOperators).name("existingOperatorStates");
            ((FlatMapOperator)existingOperatorStates.flatMap((FlatMapFunction)new StatePathExtractor()).setParallelism(1)).output((OutputFormat)new FileCopyFunction(path));
            finalOperatorStates = newOperatorStates.union((DataSet)existingOperatorStates);
        }
        ((GroupReduceOperator)finalOperatorStates.reduceGroup((GroupReduceFunction)new MergeOperatorStates(this.metadata.getMasterStates())).name("reduce(OperatorState)")).output((OutputFormat)new SavepointOutputFormat(savepointPath)).name(path);
    }

    private DataSet<OperatorState> writeOperatorStates(List<BootstrapTransformationWithID<?>> newOperatorStates, Configuration config, Path savepointWritePath) {
        return newOperatorStates.stream().map(newOperatorState -> newOperatorState.getBootstrapTransformation().writeOperatorState(newOperatorState.getOperatorID(), this.stateBackend, config, this.metadata.getMaxParallelism(), savepointWritePath)).reduce(DataSet::union).orElseThrow(() -> new IllegalStateException("Savepoint must contain at least one operator"));
    }
}

