/*
 * Apache Fineract REST API
 * Apache Fineract is a secure, multi-tenanted microfinance platform. The goal of the Apache Fineract API is to empower developers to build apps on top of the Apache Fineract Platform. The [reference app](https://cui.fineract.dev) (username: mifos, password: password) works on the same demo tenant as the interactive links in this documentation. Until we complete the new REST API documentation you still have the legacy documentation available [here](https://fineract.apache.org/docs/legacy/). Please check [the current Fineract documentation](https://fineract.apache.org/docs/current/) for more information.
 *
 * The version of the OpenAPI document: 1.14.0
 * Contact: dev@fineract.apache.org
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.apache.fineract.client.models;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.LocalDate;
import org.apache.fineract.client.models.ClientData;
import org.apache.fineract.client.models.PortfolioAccountData;

/**
 * StandingInstructionData
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", comments = "Generator version: 7.8.0")
public class StandingInstructionData {
  public static final String SERIALIZED_NAME_ACCOUNT_DETAIL_ID = "accountDetailId";
  @SerializedName(SERIALIZED_NAME_ACCOUNT_DETAIL_ID)
  private Long accountDetailId;

  public static final String SERIALIZED_NAME_AMOUNT = "amount";
  @SerializedName(SERIALIZED_NAME_AMOUNT)
  private BigDecimal amount;

  public static final String SERIALIZED_NAME_FROM_ACCOUNT = "fromAccount";
  @SerializedName(SERIALIZED_NAME_FROM_ACCOUNT)
  private PortfolioAccountData fromAccount;

  /**
   * Gets or Sets fromAccountType
   */
  @JsonAdapter(FromAccountTypeEnum.Adapter.class)
  public enum FromAccountTypeEnum {
    INVALID("INVALID"),
    
    LOAN("LOAN"),
    
    SAVINGS("SAVINGS");

    private String value;

    FromAccountTypeEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static FromAccountTypeEnum fromValue(String value) {
      for (FromAccountTypeEnum b : FromAccountTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<FromAccountTypeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final FromAccountTypeEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public FromAccountTypeEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return FromAccountTypeEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_FROM_ACCOUNT_TYPE = "fromAccountType";
  @SerializedName(SERIALIZED_NAME_FROM_ACCOUNT_TYPE)
  private FromAccountTypeEnum fromAccountType;

  public static final String SERIALIZED_NAME_FROM_CLIENT = "fromClient";
  @SerializedName(SERIALIZED_NAME_FROM_CLIENT)
  private ClientData fromClient;

  public static final String SERIALIZED_NAME_ID = "id";
  @SerializedName(SERIALIZED_NAME_ID)
  private Long id;

  /**
   * Gets or Sets instructionType
   */
  @JsonAdapter(InstructionTypeEnum.Adapter.class)
  public enum InstructionTypeEnum {
    INVALID("INVALID"),
    
    FIXED("FIXED"),
    
    DUES("DUES");

    private String value;

    InstructionTypeEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static InstructionTypeEnum fromValue(String value) {
      for (InstructionTypeEnum b : InstructionTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<InstructionTypeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final InstructionTypeEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public InstructionTypeEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return InstructionTypeEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_INSTRUCTION_TYPE = "instructionType";
  @SerializedName(SERIALIZED_NAME_INSTRUCTION_TYPE)
  private InstructionTypeEnum instructionType;

  public static final String SERIALIZED_NAME_NAME = "name";
  @SerializedName(SERIALIZED_NAME_NAME)
  private String name;

  /**
   * Gets or Sets recurrenceFrequency
   */
  @JsonAdapter(RecurrenceFrequencyEnum.Adapter.class)
  public enum RecurrenceFrequencyEnum {
    DAYS("DAYS"),
    
    WEEKS("WEEKS"),
    
    MONTHS("MONTHS"),
    
    YEARS("YEARS"),
    
    WHOLE_TERM("WHOLE_TERM"),
    
    INVALID("INVALID");

    private String value;

    RecurrenceFrequencyEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static RecurrenceFrequencyEnum fromValue(String value) {
      for (RecurrenceFrequencyEnum b : RecurrenceFrequencyEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<RecurrenceFrequencyEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final RecurrenceFrequencyEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public RecurrenceFrequencyEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return RecurrenceFrequencyEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_RECURRENCE_FREQUENCY = "recurrenceFrequency";
  @SerializedName(SERIALIZED_NAME_RECURRENCE_FREQUENCY)
  private RecurrenceFrequencyEnum recurrenceFrequency;

  public static final String SERIALIZED_NAME_RECURRENCE_INTERVAL = "recurrenceInterval";
  @SerializedName(SERIALIZED_NAME_RECURRENCE_INTERVAL)
  private Integer recurrenceInterval;

  public static final String SERIALIZED_NAME_RECURRENCE_ON_DAY = "recurrenceOnDay";
  @SerializedName(SERIALIZED_NAME_RECURRENCE_ON_DAY)
  private Integer recurrenceOnDay;

  public static final String SERIALIZED_NAME_RECURRENCE_ON_MONTH = "recurrenceOnMonth";
  @SerializedName(SERIALIZED_NAME_RECURRENCE_ON_MONTH)
  private Integer recurrenceOnMonth;

  /**
   * Gets or Sets recurrenceType
   */
  @JsonAdapter(RecurrenceTypeEnum.Adapter.class)
  public enum RecurrenceTypeEnum {
    INVALID("INVALID"),
    
    PERIODIC("PERIODIC"),
    
    AS_PER_DUES("AS_PER_DUES");

    private String value;

    RecurrenceTypeEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static RecurrenceTypeEnum fromValue(String value) {
      for (RecurrenceTypeEnum b : RecurrenceTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<RecurrenceTypeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final RecurrenceTypeEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public RecurrenceTypeEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return RecurrenceTypeEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_RECURRENCE_TYPE = "recurrenceType";
  @SerializedName(SERIALIZED_NAME_RECURRENCE_TYPE)
  private RecurrenceTypeEnum recurrenceType;

  public static final String SERIALIZED_NAME_TO_ACCOUNT = "toAccount";
  @SerializedName(SERIALIZED_NAME_TO_ACCOUNT)
  private PortfolioAccountData toAccount;

  /**
   * Gets or Sets toAccountType
   */
  @JsonAdapter(ToAccountTypeEnum.Adapter.class)
  public enum ToAccountTypeEnum {
    INVALID("INVALID"),
    
    LOAN("LOAN"),
    
    SAVINGS("SAVINGS");

    private String value;

    ToAccountTypeEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static ToAccountTypeEnum fromValue(String value) {
      for (ToAccountTypeEnum b : ToAccountTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<ToAccountTypeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final ToAccountTypeEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public ToAccountTypeEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return ToAccountTypeEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_TO_ACCOUNT_TYPE = "toAccountType";
  @SerializedName(SERIALIZED_NAME_TO_ACCOUNT_TYPE)
  private ToAccountTypeEnum toAccountType;

  public static final String SERIALIZED_NAME_TO_CLIENT = "toClient";
  @SerializedName(SERIALIZED_NAME_TO_CLIENT)
  private ClientData toClient;

  /**
   * Gets or Sets transferType
   */
  @JsonAdapter(TransferTypeEnum.Adapter.class)
  public enum TransferTypeEnum {
    INVALID("INVALID"),
    
    ACCOUNT_TRANSFER("ACCOUNT_TRANSFER"),
    
    LOAN_REPAYMENT("LOAN_REPAYMENT"),
    
    CHARGE_PAYMENT("CHARGE_PAYMENT"),
    
    INTEREST_TRANSFER("INTEREST_TRANSFER"),
    
    LOAN_DOWN_PAYMENT("LOAN_DOWN_PAYMENT");

    private String value;

    TransferTypeEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static TransferTypeEnum fromValue(String value) {
      for (TransferTypeEnum b : TransferTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<TransferTypeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final TransferTypeEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public TransferTypeEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return TransferTypeEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_TRANSFER_TYPE = "transferType";
  @SerializedName(SERIALIZED_NAME_TRANSFER_TYPE)
  private TransferTypeEnum transferType;

  public static final String SERIALIZED_NAME_VALID_FROM = "validFrom";
  @SerializedName(SERIALIZED_NAME_VALID_FROM)
  private LocalDate validFrom;

  public StandingInstructionData() {
  }

  public StandingInstructionData accountDetailId(Long accountDetailId) {
    
    this.accountDetailId = accountDetailId;
    return this;
  }

  /**
   * Get accountDetailId
   * @return accountDetailId
   */
  @javax.annotation.Nullable

  public Long getAccountDetailId() {
    return accountDetailId;
  }


  public void setAccountDetailId(Long accountDetailId) {
    this.accountDetailId = accountDetailId;
  }

  public StandingInstructionData amount(BigDecimal amount) {
    
    this.amount = amount;
    return this;
  }

  /**
   * Get amount
   * @return amount
   */
  @javax.annotation.Nullable

  public BigDecimal getAmount() {
    return amount;
  }


  public void setAmount(BigDecimal amount) {
    this.amount = amount;
  }

  public StandingInstructionData fromAccount(PortfolioAccountData fromAccount) {
    
    this.fromAccount = fromAccount;
    return this;
  }

  /**
   * Get fromAccount
   * @return fromAccount
   */
  @javax.annotation.Nullable

  public PortfolioAccountData getFromAccount() {
    return fromAccount;
  }


  public void setFromAccount(PortfolioAccountData fromAccount) {
    this.fromAccount = fromAccount;
  }

  public StandingInstructionData fromAccountType(FromAccountTypeEnum fromAccountType) {
    
    this.fromAccountType = fromAccountType;
    return this;
  }

  /**
   * Get fromAccountType
   * @return fromAccountType
   */
  @javax.annotation.Nullable

  public FromAccountTypeEnum getFromAccountType() {
    return fromAccountType;
  }


  public void setFromAccountType(FromAccountTypeEnum fromAccountType) {
    this.fromAccountType = fromAccountType;
  }

  public StandingInstructionData fromClient(ClientData fromClient) {
    
    this.fromClient = fromClient;
    return this;
  }

  /**
   * Get fromClient
   * @return fromClient
   */
  @javax.annotation.Nullable

  public ClientData getFromClient() {
    return fromClient;
  }


  public void setFromClient(ClientData fromClient) {
    this.fromClient = fromClient;
  }

  public StandingInstructionData id(Long id) {
    
    this.id = id;
    return this;
  }

  /**
   * Get id
   * @return id
   */
  @javax.annotation.Nullable

  public Long getId() {
    return id;
  }


  public void setId(Long id) {
    this.id = id;
  }

  public StandingInstructionData instructionType(InstructionTypeEnum instructionType) {
    
    this.instructionType = instructionType;
    return this;
  }

  /**
   * Get instructionType
   * @return instructionType
   */
  @javax.annotation.Nullable

  public InstructionTypeEnum getInstructionType() {
    return instructionType;
  }


  public void setInstructionType(InstructionTypeEnum instructionType) {
    this.instructionType = instructionType;
  }

  public StandingInstructionData name(String name) {
    
    this.name = name;
    return this;
  }

  /**
   * Get name
   * @return name
   */
  @javax.annotation.Nullable

  public String getName() {
    return name;
  }


  public void setName(String name) {
    this.name = name;
  }

  public StandingInstructionData recurrenceFrequency(RecurrenceFrequencyEnum recurrenceFrequency) {
    
    this.recurrenceFrequency = recurrenceFrequency;
    return this;
  }

  /**
   * Get recurrenceFrequency
   * @return recurrenceFrequency
   */
  @javax.annotation.Nullable

  public RecurrenceFrequencyEnum getRecurrenceFrequency() {
    return recurrenceFrequency;
  }


  public void setRecurrenceFrequency(RecurrenceFrequencyEnum recurrenceFrequency) {
    this.recurrenceFrequency = recurrenceFrequency;
  }

  public StandingInstructionData recurrenceInterval(Integer recurrenceInterval) {
    
    this.recurrenceInterval = recurrenceInterval;
    return this;
  }

  /**
   * Get recurrenceInterval
   * @return recurrenceInterval
   */
  @javax.annotation.Nullable

  public Integer getRecurrenceInterval() {
    return recurrenceInterval;
  }


  public void setRecurrenceInterval(Integer recurrenceInterval) {
    this.recurrenceInterval = recurrenceInterval;
  }

  public StandingInstructionData recurrenceOnDay(Integer recurrenceOnDay) {
    
    this.recurrenceOnDay = recurrenceOnDay;
    return this;
  }

  /**
   * Get recurrenceOnDay
   * @return recurrenceOnDay
   */
  @javax.annotation.Nullable

  public Integer getRecurrenceOnDay() {
    return recurrenceOnDay;
  }


  public void setRecurrenceOnDay(Integer recurrenceOnDay) {
    this.recurrenceOnDay = recurrenceOnDay;
  }

  public StandingInstructionData recurrenceOnMonth(Integer recurrenceOnMonth) {
    
    this.recurrenceOnMonth = recurrenceOnMonth;
    return this;
  }

  /**
   * Get recurrenceOnMonth
   * @return recurrenceOnMonth
   */
  @javax.annotation.Nullable

  public Integer getRecurrenceOnMonth() {
    return recurrenceOnMonth;
  }


  public void setRecurrenceOnMonth(Integer recurrenceOnMonth) {
    this.recurrenceOnMonth = recurrenceOnMonth;
  }

  public StandingInstructionData recurrenceType(RecurrenceTypeEnum recurrenceType) {
    
    this.recurrenceType = recurrenceType;
    return this;
  }

  /**
   * Get recurrenceType
   * @return recurrenceType
   */
  @javax.annotation.Nullable

  public RecurrenceTypeEnum getRecurrenceType() {
    return recurrenceType;
  }


  public void setRecurrenceType(RecurrenceTypeEnum recurrenceType) {
    this.recurrenceType = recurrenceType;
  }

  public StandingInstructionData toAccount(PortfolioAccountData toAccount) {
    
    this.toAccount = toAccount;
    return this;
  }

  /**
   * Get toAccount
   * @return toAccount
   */
  @javax.annotation.Nullable

  public PortfolioAccountData getToAccount() {
    return toAccount;
  }


  public void setToAccount(PortfolioAccountData toAccount) {
    this.toAccount = toAccount;
  }

  public StandingInstructionData toAccountType(ToAccountTypeEnum toAccountType) {
    
    this.toAccountType = toAccountType;
    return this;
  }

  /**
   * Get toAccountType
   * @return toAccountType
   */
  @javax.annotation.Nullable

  public ToAccountTypeEnum getToAccountType() {
    return toAccountType;
  }


  public void setToAccountType(ToAccountTypeEnum toAccountType) {
    this.toAccountType = toAccountType;
  }

  public StandingInstructionData toClient(ClientData toClient) {
    
    this.toClient = toClient;
    return this;
  }

  /**
   * Get toClient
   * @return toClient
   */
  @javax.annotation.Nullable

  public ClientData getToClient() {
    return toClient;
  }


  public void setToClient(ClientData toClient) {
    this.toClient = toClient;
  }

  public StandingInstructionData transferType(TransferTypeEnum transferType) {
    
    this.transferType = transferType;
    return this;
  }

  /**
   * Get transferType
   * @return transferType
   */
  @javax.annotation.Nullable

  public TransferTypeEnum getTransferType() {
    return transferType;
  }


  public void setTransferType(TransferTypeEnum transferType) {
    this.transferType = transferType;
  }

  public StandingInstructionData validFrom(LocalDate validFrom) {
    
    this.validFrom = validFrom;
    return this;
  }

  /**
   * Get validFrom
   * @return validFrom
   */
  @javax.annotation.Nullable

  public LocalDate getValidFrom() {
    return validFrom;
  }


  public void setValidFrom(LocalDate validFrom) {
    this.validFrom = validFrom;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    StandingInstructionData standingInstructionData = (StandingInstructionData) o;
    return Objects.equals(this.accountDetailId, standingInstructionData.accountDetailId) &&
        Objects.equals(this.amount, standingInstructionData.amount) &&
        Objects.equals(this.fromAccount, standingInstructionData.fromAccount) &&
        Objects.equals(this.fromAccountType, standingInstructionData.fromAccountType) &&
        Objects.equals(this.fromClient, standingInstructionData.fromClient) &&
        Objects.equals(this.id, standingInstructionData.id) &&
        Objects.equals(this.instructionType, standingInstructionData.instructionType) &&
        Objects.equals(this.name, standingInstructionData.name) &&
        Objects.equals(this.recurrenceFrequency, standingInstructionData.recurrenceFrequency) &&
        Objects.equals(this.recurrenceInterval, standingInstructionData.recurrenceInterval) &&
        Objects.equals(this.recurrenceOnDay, standingInstructionData.recurrenceOnDay) &&
        Objects.equals(this.recurrenceOnMonth, standingInstructionData.recurrenceOnMonth) &&
        Objects.equals(this.recurrenceType, standingInstructionData.recurrenceType) &&
        Objects.equals(this.toAccount, standingInstructionData.toAccount) &&
        Objects.equals(this.toAccountType, standingInstructionData.toAccountType) &&
        Objects.equals(this.toClient, standingInstructionData.toClient) &&
        Objects.equals(this.transferType, standingInstructionData.transferType) &&
        Objects.equals(this.validFrom, standingInstructionData.validFrom);
  }

  @Override
  public int hashCode() {
    return Objects.hash(accountDetailId, amount, fromAccount, fromAccountType, fromClient, id, instructionType, name, recurrenceFrequency, recurrenceInterval, recurrenceOnDay, recurrenceOnMonth, recurrenceType, toAccount, toAccountType, toClient, transferType, validFrom);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class StandingInstructionData {\n");
    sb.append("    accountDetailId: ").append(toIndentedString(accountDetailId)).append("\n");
    sb.append("    amount: ").append(toIndentedString(amount)).append("\n");
    sb.append("    fromAccount: ").append(toIndentedString(fromAccount)).append("\n");
    sb.append("    fromAccountType: ").append(toIndentedString(fromAccountType)).append("\n");
    sb.append("    fromClient: ").append(toIndentedString(fromClient)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    instructionType: ").append(toIndentedString(instructionType)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    recurrenceFrequency: ").append(toIndentedString(recurrenceFrequency)).append("\n");
    sb.append("    recurrenceInterval: ").append(toIndentedString(recurrenceInterval)).append("\n");
    sb.append("    recurrenceOnDay: ").append(toIndentedString(recurrenceOnDay)).append("\n");
    sb.append("    recurrenceOnMonth: ").append(toIndentedString(recurrenceOnMonth)).append("\n");
    sb.append("    recurrenceType: ").append(toIndentedString(recurrenceType)).append("\n");
    sb.append("    toAccount: ").append(toIndentedString(toAccount)).append("\n");
    sb.append("    toAccountType: ").append(toIndentedString(toAccountType)).append("\n");
    sb.append("    toClient: ").append(toIndentedString(toClient)).append("\n");
    sb.append("    transferType: ").append(toIndentedString(transferType)).append("\n");
    sb.append("    validFrom: ").append(toIndentedString(validFrom)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

