/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.savings.jobs.generaterdschedule;

import org.apache.fineract.infrastructure.core.service.database.RoutingDataSourceServiceFactory;
import org.apache.fineract.infrastructure.jobs.service.JobName;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.portfolio.savings.jobs.generaterdschedule.GenerateRdScheduleTasklet;
import org.apache.fineract.portfolio.savings.service.DepositAccountReadPlatformService;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobParametersIncrementer;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.job.builder.JobBuilder;
import org.springframework.batch.core.job.builder.SimpleJobBuilder;
import org.springframework.batch.core.launch.support.RunIdIncrementer;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.batch.core.step.builder.StepBuilder;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.transaction.PlatformTransactionManager;

@Configuration
public class GenerateRdScheduleConfig {
    @Autowired
    private JobRepository jobRepository;
    @Autowired
    private PlatformTransactionManager transactionManager;
    @Autowired
    private RoutingDataSourceServiceFactory dataSourceServiceFactory;
    @Autowired
    private DepositAccountReadPlatformService depositAccountReadPlatformService;
    @Autowired
    private PlatformSecurityContext securityContext;

    @Bean
    protected Step generateRdScheduleStep() {
        return new StepBuilder(JobName.GENERATE_RD_SCEHDULE.name(), this.jobRepository).tasklet((Tasklet)this.generateRdScheduleTasklet(), this.transactionManager).build();
    }

    @Bean
    public Job generateRdScheduleJob() {
        return ((SimpleJobBuilder)new JobBuilder(JobName.GENERATE_RD_SCEHDULE.name(), this.jobRepository).start(this.generateRdScheduleStep()).incrementer((JobParametersIncrementer)new RunIdIncrementer())).build();
    }

    @Bean
    public GenerateRdScheduleTasklet generateRdScheduleTasklet() {
        return new GenerateRdScheduleTasklet(this.dataSourceServiceFactory, this.depositAccountReadPlatformService, this.securityContext);
    }
}

