/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.loanaccount.service;

import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.organisation.staff.data.StaffAccountSummaryCollectionData;
import org.apache.fineract.portfolio.accountdetails.service.AccountDetailsReadPlatformService;
import org.apache.fineract.portfolio.client.domain.ClientStatus;
import org.apache.fineract.portfolio.group.domain.GroupingTypeStatus;
import org.apache.fineract.portfolio.loanaccount.service.BulkLoansReadPlatformService;
import org.apache.fineract.portfolio.loanaccount.service.BulkLoansReadPlatformServiceImpl;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

public class BulkLoansReadPlatformServiceImpl
implements BulkLoansReadPlatformService {
    private final JdbcTemplate jdbcTemplate;
    private final PlatformSecurityContext context;
    private final AccountDetailsReadPlatformService accountDetailsReadPlatformService;

    public StaffAccountSummaryCollectionData retrieveLoanOfficerAccountSummary(Long loanOfficerId) {
        this.context.authenticatedUser();
        StaffClientMapper staffClientMapper = new StaffClientMapper();
        String clientSql = "select distinct " + staffClientMapper.schema() + " and c.status_enum=?";
        StaffGroupMapper staffGroupMapper = new StaffGroupMapper();
        String groupSql = "select distinct " + staffGroupMapper.schema() + " and g.status_enum=?";
        List clientSummaryList = this.jdbcTemplate.query(clientSql, (RowMapper)staffClientMapper, new Object[]{loanOfficerId, ClientStatus.ACTIVE.getValue()});
        for (StaffAccountSummaryCollectionData.LoanAccountSummary clientSummary : clientSummaryList) {
            Collection clientLoanAccounts = this.accountDetailsReadPlatformService.retrieveClientLoanAccountsByLoanOfficerId(clientSummary.getId(), loanOfficerId);
            clientSummary.setLoans(clientLoanAccounts);
        }
        List groupSummaryList = this.jdbcTemplate.query(groupSql, (RowMapper)staffGroupMapper, new Object[]{loanOfficerId, GroupingTypeStatus.ACTIVE.getValue()});
        for (StaffAccountSummaryCollectionData.LoanAccountSummary groupSummary : groupSummaryList) {
            Collection groupLoanAccounts = this.accountDetailsReadPlatformService.retrieveGroupLoanAccountsByLoanOfficerId(groupSummary.getId(), loanOfficerId);
            groupSummary.setLoans(groupLoanAccounts);
        }
        return new StaffAccountSummaryCollectionData(clientSummaryList, groupSummaryList);
    }

    @Generated
    public BulkLoansReadPlatformServiceImpl(JdbcTemplate jdbcTemplate, PlatformSecurityContext context, AccountDetailsReadPlatformService accountDetailsReadPlatformService) {
        this.jdbcTemplate = jdbcTemplate;
        this.context = context;
        this.accountDetailsReadPlatformService = accountDetailsReadPlatformService;
    }
}

