/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.client.service;

import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.apache.fineract.accounting.journalentry.service.JournalEntryWritePlatformService;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResultBuilder;
import org.apache.fineract.organisation.monetary.domain.OrganisationCurrencyRepositoryWrapper;
import org.apache.fineract.portfolio.client.domain.Client;
import org.apache.fineract.portfolio.client.domain.ClientCharge;
import org.apache.fineract.portfolio.client.domain.ClientChargePaidBy;
import org.apache.fineract.portfolio.client.domain.ClientRepositoryWrapper;
import org.apache.fineract.portfolio.client.domain.ClientTransaction;
import org.apache.fineract.portfolio.client.domain.ClientTransactionRepositoryWrapper;
import org.apache.fineract.portfolio.client.exception.ClientTransactionCannotBeUndoneException;
import org.apache.fineract.portfolio.client.service.ClientTransactionWritePlatformService;
import org.springframework.stereotype.Service;

@Service
public class ClientTransactionWritePlatformServiceJpaRepositoryImpl
implements ClientTransactionWritePlatformService {
    private final ClientTransactionRepositoryWrapper clientTransactionRepository;
    private final ClientRepositoryWrapper clientRepository;
    private final OrganisationCurrencyRepositoryWrapper organisationCurrencyRepository;
    private final JournalEntryWritePlatformService journalEntryWritePlatformService;

    public CommandProcessingResult undo(Long clientId, Long transactionId) {
        Client client = this.clientRepository.getActiveClientInUserScope(clientId);
        ClientTransaction clientTransaction = this.clientTransactionRepository.findOneWithNotFoundDetection(clientId, transactionId);
        if (clientTransaction.isReversed()) {
            throw new ClientTransactionCannotBeUndoneException(clientId.longValue(), transactionId);
        }
        clientTransaction.reverse();
        if (clientTransaction.isPayChargeTransaction() || clientTransaction.isWaiveChargeTransaction()) {
            Set chargesPaidBy = clientTransaction.getClientChargePaidByCollection();
            for (ClientChargePaidBy clientChargePaidBy : chargesPaidBy) {
                ClientCharge clientCharge = clientChargePaidBy.getClientCharge();
                clientCharge.setCurrency(this.organisationCurrencyRepository.findOneWithNotFoundDetection(clientCharge.getCharge().getCurrencyCode()));
                if (clientTransaction.isPayChargeTransaction()) {
                    clientCharge.undoPayment(clientTransaction.getAmount());
                    continue;
                }
                if (!clientTransaction.isWaiveChargeTransaction()) continue;
                clientCharge.undoWaiver(clientTransaction.getAmount());
            }
        }
        this.clientTransactionRepository.saveAndFlush(clientTransaction);
        this.generateAccountingEntries(clientTransaction);
        return new CommandProcessingResultBuilder().withEntityId(transactionId).withOfficeId(client.officeId()).withClientId(clientId).build();
    }

    private void generateAccountingEntries(ClientTransaction clientTransaction) {
        Map accountingBridgeData = clientTransaction.toMapData();
        this.journalEntryWritePlatformService.createJournalEntriesForClientTransactions(accountingBridgeData);
    }

    @Generated
    public ClientTransactionWritePlatformServiceJpaRepositoryImpl(ClientTransactionRepositoryWrapper clientTransactionRepository, ClientRepositoryWrapper clientRepository, OrganisationCurrencyRepositoryWrapper organisationCurrencyRepository, JournalEntryWritePlatformService journalEntryWritePlatformService) {
        this.clientTransactionRepository = clientTransactionRepository;
        this.clientRepository = clientRepository;
        this.organisationCurrencyRepository = organisationCurrencyRepository;
        this.journalEntryWritePlatformService = journalEntryWritePlatformService;
    }
}

