/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.client.service;

import jakarta.persistence.PersistenceException;
import java.util.Map;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.fineract.infrastructure.codes.domain.CodeValue;
import org.apache.fineract.infrastructure.codes.domain.CodeValueRepositoryWrapper;
import org.apache.fineract.infrastructure.codes.exception.CodeValueNotFoundException;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResultBuilder;
import org.apache.fineract.infrastructure.core.exception.ErrorHandler;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.portfolio.client.command.ClientIdentifierCommand;
import org.apache.fineract.portfolio.client.domain.Client;
import org.apache.fineract.portfolio.client.domain.ClientIdentifier;
import org.apache.fineract.portfolio.client.domain.ClientIdentifierRepository;
import org.apache.fineract.portfolio.client.domain.ClientRepositoryWrapper;
import org.apache.fineract.portfolio.client.exception.ClientIdentifierNotFoundException;
import org.apache.fineract.portfolio.client.exception.DuplicateClientIdentifierException;
import org.apache.fineract.portfolio.client.serialization.ClientIdentifierCommandFromApiJsonDeserializer;
import org.apache.fineract.portfolio.client.service.ClientIdentifierWritePlatformService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.orm.jpa.JpaSystemException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ClientIdentifierWritePlatformServiceJpaRepositoryImpl
implements ClientIdentifierWritePlatformService {
    private static final Logger LOG = LoggerFactory.getLogger(ClientIdentifierWritePlatformServiceJpaRepositoryImpl.class);
    private final PlatformSecurityContext context;
    private final ClientRepositoryWrapper clientRepository;
    private final ClientIdentifierRepository clientIdentifierRepository;
    private final CodeValueRepositoryWrapper codeValueRepository;
    private final ClientIdentifierCommandFromApiJsonDeserializer clientIdentifierCommandFromApiJsonDeserializer;

    @Autowired
    public ClientIdentifierWritePlatformServiceJpaRepositoryImpl(PlatformSecurityContext context, ClientRepositoryWrapper clientRepository, ClientIdentifierRepository clientIdentifierRepository, CodeValueRepositoryWrapper codeValueRepository, ClientIdentifierCommandFromApiJsonDeserializer clientIdentifierCommandFromApiJsonDeserializer) {
        this.context = context;
        this.clientRepository = clientRepository;
        this.clientIdentifierRepository = clientIdentifierRepository;
        this.codeValueRepository = codeValueRepository;
        this.clientIdentifierCommandFromApiJsonDeserializer = clientIdentifierCommandFromApiJsonDeserializer;
    }

    @Transactional
    public CommandProcessingResult addClientIdentifier(Long clientId, JsonCommand command) {
        this.context.authenticatedUser();
        ClientIdentifierCommand clientIdentifierCommand = this.clientIdentifierCommandFromApiJsonDeserializer.commandFromApiJson(command.json());
        clientIdentifierCommand.validateForCreate();
        String documentKey = clientIdentifierCommand.getDocumentKey();
        String documentTypeLabel = null;
        Long documentTypeId = null;
        try {
            Client client = this.clientRepository.findOneWithNotFoundDetection(clientId);
            CodeValue documentType = this.codeValueRepository.findOneWithNotFoundDetection(clientIdentifierCommand.getDocumentTypeId());
            documentTypeId = (Long)documentType.getId();
            documentTypeLabel = documentType.getLabel();
            ClientIdentifier clientIdentifier = ClientIdentifier.fromJson((Client)client, (CodeValue)documentType, (JsonCommand)command);
            this.clientIdentifierRepository.saveAndFlush((Object)clientIdentifier);
            return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withOfficeId(client.officeId()).withClientId(clientId).withEntityId((Long)clientIdentifier.getId()).build();
        }
        catch (DataIntegrityViolationException | JpaSystemException dve) {
            this.handleClientIdentifierDataIntegrityViolation(documentTypeLabel, documentTypeId, documentKey, dve.getMostSpecificCause(), (Exception)dve);
            return CommandProcessingResult.empty();
        }
        catch (PersistenceException dve) {
            Throwable throwable = ExceptionUtils.getRootCause((Throwable)dve.getCause());
            this.handleClientIdentifierDataIntegrityViolation(documentTypeLabel, documentTypeId, documentKey, throwable, (Exception)((Object)dve));
            return CommandProcessingResult.empty();
        }
    }

    @Transactional
    public CommandProcessingResult updateClientIdentifier(Long clientId, Long identifierId, JsonCommand command) {
        this.context.authenticatedUser();
        ClientIdentifierCommand clientIdentifierCommand = this.clientIdentifierCommandFromApiJsonDeserializer.commandFromApiJson(command.json());
        clientIdentifierCommand.validateForUpdate();
        String documentTypeLabel = null;
        String documentKey = null;
        Long documentTypeId = clientIdentifierCommand.getDocumentTypeId();
        try {
            CodeValue documentType = null;
            Client client = this.clientRepository.findOneWithNotFoundDetection(clientId);
            ClientIdentifier clientIdentifierForUpdate = (ClientIdentifier)this.clientIdentifierRepository.findById((Object)identifierId).orElseThrow(() -> new ClientIdentifierNotFoundException(identifierId));
            Map changes = clientIdentifierForUpdate.update(command);
            if (changes.containsKey("documentTypeId")) {
                documentType = this.codeValueRepository.findOneWithNotFoundDetection(documentTypeId);
                if (documentType == null) {
                    throw new CodeValueNotFoundException(documentTypeId);
                }
                documentTypeId = (Long)documentType.getId();
                documentTypeLabel = documentType.getLabel();
                clientIdentifierForUpdate.update(documentType);
            }
            if (changes.containsKey("documentTypeId") && changes.containsKey("documentKey")) {
                documentTypeId = clientIdentifierCommand.getDocumentTypeId();
                documentKey = clientIdentifierCommand.getDocumentKey();
            } else if (changes.containsKey("documentTypeId") && !changes.containsKey("documentKey")) {
                documentTypeId = clientIdentifierCommand.getDocumentTypeId();
                documentKey = clientIdentifierForUpdate.documentKey();
            } else if (!changes.containsKey("documentTypeId") && changes.containsKey("documentKey")) {
                documentTypeId = clientIdentifierForUpdate.documentTypeId();
                documentKey = clientIdentifierForUpdate.documentKey();
            }
            if (!changes.isEmpty()) {
                this.clientIdentifierRepository.saveAndFlush((Object)clientIdentifierForUpdate);
            }
            return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withOfficeId(client.officeId()).withClientId(clientId).withEntityId(identifierId).with(changes).build();
        }
        catch (DataIntegrityViolationException | JpaSystemException dve) {
            this.handleClientIdentifierDataIntegrityViolation(documentTypeLabel, documentTypeId, documentKey, dve.getMostSpecificCause(), (Exception)dve);
            return CommandProcessingResult.resourceResult((Long)-1L);
        }
        catch (PersistenceException dve) {
            Throwable throwable = ExceptionUtils.getRootCause((Throwable)dve.getCause());
            this.handleClientIdentifierDataIntegrityViolation(documentTypeLabel, documentTypeId, documentKey, throwable, (Exception)((Object)dve));
            return CommandProcessingResult.empty();
        }
    }

    @Transactional
    public CommandProcessingResult deleteClientIdentifier(Long clientId, Long identifierId, Long commandId) {
        Client client = this.clientRepository.findOneWithNotFoundDetection(clientId);
        ClientIdentifier clientIdentifier = (ClientIdentifier)this.clientIdentifierRepository.findById((Object)identifierId).orElseThrow(() -> new ClientIdentifierNotFoundException(identifierId));
        this.clientIdentifierRepository.delete((Object)clientIdentifier);
        return new CommandProcessingResultBuilder().withCommandId(commandId).withOfficeId(client.officeId()).withClientId(clientId).withEntityId(identifierId).build();
    }

    private void handleClientIdentifierDataIntegrityViolation(String documentTypeLabel, Long documentTypeId, String documentKey, Throwable cause, Exception dve) {
        if (cause.getMessage().contains("unique_active_client_identifier")) {
            throw new DuplicateClientIdentifierException(documentTypeLabel);
        }
        if (cause.getMessage().contains("unique_identifier_key")) {
            throw new DuplicateClientIdentifierException(documentTypeId, documentTypeLabel, documentKey);
        }
        this.logAsErrorUnexpectedDataIntegrityException(dve);
        throw ErrorHandler.getMappable((Throwable)dve, (String)"error.msg.clientIdentifier.unknown.data.integrity.issue", (String)"Unknown data integrity issue with resource.");
    }

    private void logAsErrorUnexpectedDataIntegrityException(Exception dve) {
        LOG.error("Error occured.", (Throwable)dve);
    }
}

