/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.survey.service;

import java.util.List;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResultBuilder;
import org.apache.fineract.infrastructure.core.exception.ErrorHandler;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.infrastructure.survey.data.LikelihoodDataValidator;
import org.apache.fineract.infrastructure.survey.domain.Likelihood;
import org.apache.fineract.infrastructure.survey.domain.LikelihoodRepository;
import org.apache.fineract.infrastructure.survey.service.WriteLikelihoodService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.NonTransientDataAccessException;
import org.springframework.orm.jpa.JpaSystemException;
import org.springframework.stereotype.Service;

@Service
public class WriteLikelihoodServiceImpl
implements WriteLikelihoodService {
    private static final Logger LOG = LoggerFactory.getLogger(WriteLikelihoodServiceImpl.class);
    private final PlatformSecurityContext context;
    private final LikelihoodDataValidator likelihoodDataValidator;
    private final LikelihoodRepository repository;

    @Autowired
    WriteLikelihoodServiceImpl(PlatformSecurityContext context, LikelihoodDataValidator likelihoodDataValidator, LikelihoodRepository repository) {
        this.context = context;
        this.likelihoodDataValidator = likelihoodDataValidator;
        this.repository = repository;
    }

    public CommandProcessingResult update(Long likelihoodId, JsonCommand command) {
        this.context.authenticatedUser();
        try {
            this.likelihoodDataValidator.validateForUpdate(command);
            Likelihood likelihood = this.repository.findById((Object)likelihoodId).orElse(null);
            if (!likelihood.update(command).isEmpty()) {
                this.repository.save((Object)likelihood);
                if (likelihood.isActivateCommand(command)) {
                    List likelihoods = this.repository.findByPpiNameAndLikeliHoodId(likelihood.getPpiName(), (Long)likelihood.getId());
                    for (Likelihood aLikelihood : likelihoods) {
                        aLikelihood.setEnabled(Long.valueOf(100L));
                    }
                    this.repository.saveAll((Iterable)likelihoods);
                }
            }
            return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId((Long)likelihood.getId()).build();
        }
        catch (DataIntegrityViolationException | JpaSystemException dve) {
            Throwable throwable = dve.getMostSpecificCause();
            this.handleDataIntegrityIssues(throwable, (NonTransientDataAccessException)dve);
            return CommandProcessingResult.empty();
        }
    }

    private void handleDataIntegrityIssues(Throwable realCause, NonTransientDataAccessException dve) {
        LOG.error("Error occured.", (Throwable)dve);
        throw ErrorHandler.getMappable((Throwable)dve, (String)"error.msg.likelihood.unknown.data.integrity.issue", (String)("Unknown data integrity issue with resource: " + realCause.getMessage()));
    }
}

