/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.event.external.service.serialization.serializer.loan;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;
import java.util.function.BiFunction;
import lombok.Generated;
import org.apache.avro.generic.GenericContainer;
import org.apache.fineract.avro.generator.ByteBufferSerializable;
import org.apache.fineract.avro.loan.v1.DelinquencyRangeDataV1;
import org.apache.fineract.avro.loan.v1.LoanAccountDelinquencyRangeDataV1;
import org.apache.fineract.avro.loan.v1.LoanAmountDataV1;
import org.apache.fineract.avro.loan.v1.LoanChargeDataRangeViewV1;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.infrastructure.event.business.domain.BusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.LoanDelinquencyRangeChangeBusinessEvent;
import org.apache.fineract.infrastructure.event.external.service.serialization.mapper.generic.CurrencyDataMapper;
import org.apache.fineract.infrastructure.event.external.service.serialization.mapper.loan.LoanChargeDataMapper;
import org.apache.fineract.infrastructure.event.external.service.serialization.mapper.loan.LoanDelinquencyRangeDataMapper;
import org.apache.fineract.infrastructure.event.external.service.serialization.mapper.support.AvroDateTimeMapper;
import org.apache.fineract.infrastructure.event.external.service.serialization.serializer.AbstractBusinessEventWithCustomDataSerializer;
import org.apache.fineract.infrastructure.event.external.service.serialization.serializer.ExternalEventCustomDataSerializer;
import org.apache.fineract.infrastructure.event.external.service.serialization.serializer.loan.LoanInstallmentLevelDelinquencyEventProducer;
import org.apache.fineract.organisation.monetary.domain.MonetaryCurrency;
import org.apache.fineract.portfolio.delinquency.service.DelinquencyReadPlatformService;
import org.apache.fineract.portfolio.loanaccount.data.CollectionData;
import org.apache.fineract.portfolio.loanaccount.data.LoanAccountData;
import org.apache.fineract.portfolio.loanaccount.domain.Loan;
import org.apache.fineract.portfolio.loanaccount.domain.LoanRepaymentScheduleInstallment;
import org.apache.fineract.portfolio.loanaccount.service.LoanChargeReadPlatformService;
import org.apache.fineract.portfolio.loanaccount.service.LoanReadPlatformService;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=0x7FFFFFFE)
public class LoanDelinquencyRangeChangeBusinessEventSerializer
extends AbstractBusinessEventWithCustomDataSerializer<LoanDelinquencyRangeChangeBusinessEvent> {
    private final LoanReadPlatformService service;
    private final LoanDelinquencyRangeDataMapper mapper;
    private final LoanChargeReadPlatformService loanChargeReadPlatformService;
    private final DelinquencyReadPlatformService delinquencyReadPlatformService;
    private final LoanChargeDataMapper chargeMapper;
    private final CurrencyDataMapper currencyMapper;
    private final AvroDateTimeMapper dataTimeMapper;
    private final LoanInstallmentLevelDelinquencyEventProducer installmentLevelDelinquencyEventProducer;
    private final List<ExternalEventCustomDataSerializer<LoanDelinquencyRangeChangeBusinessEvent>> externalEventCustomDataSerializers;

    public <T> ByteBufferSerializable toAvroDTO(BusinessEvent<T> rawEvent) {
        LoanDelinquencyRangeChangeBusinessEvent event = (LoanDelinquencyRangeChangeBusinessEvent)rawEvent;
        LoanAccountData data = this.service.retrieveOne((Long)((Loan)event.get()).getId());
        Long id = data.getId();
        String accountNumber = data.getAccountNo();
        String externalId = data.getExternalId().getValue();
        MonetaryCurrency loanCurrency = ((Loan)event.get()).getCurrency();
        CollectionData delinquentData = this.delinquencyReadPlatformService.calculateLoanCollectionData(id);
        String delinquentDate = this.dataTimeMapper.mapLocalDate(delinquentData.getDelinquentDate());
        List<LoanChargeDataRangeViewV1> charges = this.loanChargeReadPlatformService.retrieveLoanCharges(id).stream().map(arg_0 -> ((LoanChargeDataMapper)this.chargeMapper).mapRangeView(arg_0)).toList();
        LoanAmountDataV1 amount = LoanAmountDataV1.newBuilder().setPrincipalAmount(this.calculateDataSummary((Loan)event.get(), (loan, installment) -> installment.getPrincipalOutstanding(loanCurrency).getAmount())).setFeeAmount(this.calculateDataSummary((Loan)event.get(), (loan, installment) -> installment.getFeeChargesOutstanding(loanCurrency).getAmount())).setInterestAmount(this.calculateDataSummary((Loan)event.get(), (loan, installment) -> installment.getInterestOutstanding(loanCurrency).getAmount())).setPenaltyAmount(this.calculateDataSummary((Loan)event.get(), (loan, installment) -> installment.getPenaltyChargesOutstanding(loanCurrency).getAmount())).setTotalAmount(this.calculateDataSummary((Loan)event.get(), (loan, installment) -> installment.getTotalOutstanding(loanCurrency).getAmount())).build();
        DelinquencyRangeDataV1 delinquencyRange = this.mapper.map(data.getDelinquencyRange());
        List installmentsDelinquencyData = this.installmentLevelDelinquencyEventProducer.calculateInstallmentLevelDelinquencyData((Loan)event.get(), data.getCurrency());
        LoanAccountDelinquencyRangeDataV1.Builder builder = LoanAccountDelinquencyRangeDataV1.newBuilder();
        return builder.setLoanId(id.longValue()).setLoanAccountNo(accountNumber).setLoanExternalId(externalId).setDelinquencyRange(delinquencyRange).setCharges(charges).setAmount(amount).setCurrency(this.currencyMapper.map(data.getCurrency())).setDelinquentDate(delinquentDate).setInstallmentDelinquencyBuckets(installmentsDelinquencyData).setCustomData(this.collectCustomData((BusinessEvent)event)).build();
    }

    private BigDecimal calculateDataSummary(Loan loan, BiFunction<Loan, LoanRepaymentScheduleInstallment, BigDecimal> mapper) {
        return loan.getRepaymentScheduleInstallments().stream().filter(installment -> DateUtils.isBeforeBusinessDate((LocalDate)installment.getDueDate())).map(installment -> (BigDecimal)mapper.apply(loan, (LoanRepaymentScheduleInstallment)installment)).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    public <T> boolean canSerialize(BusinessEvent<T> event) {
        return event instanceof LoanDelinquencyRangeChangeBusinessEvent;
    }

    public Class<? extends GenericContainer> getSupportedSchema() {
        return LoanAccountDelinquencyRangeDataV1.class;
    }

    protected List<ExternalEventCustomDataSerializer<LoanDelinquencyRangeChangeBusinessEvent>> getExternalEventCustomDataSerializers() {
        return this.externalEventCustomDataSerializers;
    }

    @Generated
    public LoanDelinquencyRangeChangeBusinessEventSerializer(LoanReadPlatformService service, LoanDelinquencyRangeDataMapper mapper, LoanChargeReadPlatformService loanChargeReadPlatformService, DelinquencyReadPlatformService delinquencyReadPlatformService, LoanChargeDataMapper chargeMapper, CurrencyDataMapper currencyMapper, AvroDateTimeMapper dataTimeMapper, LoanInstallmentLevelDelinquencyEventProducer installmentLevelDelinquencyEventProducer, List<ExternalEventCustomDataSerializer<LoanDelinquencyRangeChangeBusinessEvent>> externalEventCustomDataSerializers) {
        this.service = service;
        this.mapper = mapper;
        this.loanChargeReadPlatformService = loanChargeReadPlatformService;
        this.delinquencyReadPlatformService = delinquencyReadPlatformService;
        this.chargeMapper = chargeMapper;
        this.currencyMapper = currencyMapper;
        this.dataTimeMapper = dataTimeMapper;
        this.installmentLevelDelinquencyEventProducer = installmentLevelDelinquencyEventProducer;
        this.externalEventCustomDataSerializers = externalEventCustomDataSerializers;
    }
}

