/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.configuration.service;

import java.util.Map;
import lombok.Generated;
import org.apache.fineract.infrastructure.configuration.data.GlobalConfigurationDataValidator;
import org.apache.fineract.infrastructure.configuration.domain.ConfigurationDomainService;
import org.apache.fineract.infrastructure.configuration.domain.GlobalConfigurationProperty;
import org.apache.fineract.infrastructure.configuration.domain.GlobalConfigurationRepositoryWrapper;
import org.apache.fineract.infrastructure.configuration.service.GlobalConfigurationPropertyUpdateService;
import org.apache.fineract.infrastructure.configuration.service.GlobalConfigurationWritePlatformService;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResultBuilder;
import org.apache.fineract.infrastructure.core.exception.ErrorHandler;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.NonTransientDataAccessException;
import org.springframework.orm.jpa.JpaSystemException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class GlobalConfigurationWritePlatformServiceJpaRepositoryImpl
implements GlobalConfigurationWritePlatformService {
    private static final Logger LOG = LoggerFactory.getLogger(GlobalConfigurationWritePlatformServiceJpaRepositoryImpl.class);
    private final PlatformSecurityContext context;
    private final GlobalConfigurationRepositoryWrapper repository;
    private final GlobalConfigurationDataValidator globalConfigurationDataValidator;
    private final ConfigurationDomainService configurationDomainService;
    private final GlobalConfigurationPropertyUpdateService globalConfigurationPropertyUpdateService;

    @Transactional
    public CommandProcessingResult update(Long configId, JsonCommand command) {
        try {
            this.globalConfigurationDataValidator.validateForUpdate(command);
            GlobalConfigurationProperty configItemForUpdate = this.repository.findOneWithNotFoundDetection(configId);
            Map changes = this.globalConfigurationPropertyUpdateService.update(configItemForUpdate, command);
            if (!changes.isEmpty()) {
                this.configurationDomainService.removeGlobalConfigurationPropertyDataFromCache(configItemForUpdate.getName());
                this.repository.save(configItemForUpdate);
            }
            return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId(configId).with(changes).build();
        }
        catch (DataIntegrityViolationException | JpaSystemException dve) {
            Throwable throwable = dve.getMostSpecificCause();
            this.handleDataIntegrityIssues(throwable, (NonTransientDataAccessException)dve);
            return CommandProcessingResult.empty();
        }
    }

    @Transactional
    public void addSurveyConfig(String name) {
        try {
            GlobalConfigurationProperty ppi = GlobalConfigurationProperty.newSurveyConfiguration((String)name);
            this.repository.save(ppi);
        }
        catch (DataIntegrityViolationException | JpaSystemException dve) {
            Throwable throwable = dve.getMostSpecificCause();
            this.handleDataIntegrityIssues(throwable, (NonTransientDataAccessException)dve);
        }
    }

    private void handleDataIntegrityIssues(Throwable realCause, NonTransientDataAccessException dve) {
        LOG.error("Error occured.", (Throwable)dve);
        throw ErrorHandler.getMappable((Throwable)dve, (String)"error.msg.globalConfiguration.unknown.data.integrity.issue", (String)("Unknown data integrity issue with resource: " + realCause.getMessage()));
    }

    @Generated
    public GlobalConfigurationWritePlatformServiceJpaRepositoryImpl(PlatformSecurityContext context, GlobalConfigurationRepositoryWrapper repository, GlobalConfigurationDataValidator globalConfigurationDataValidator, ConfigurationDomainService configurationDomainService, GlobalConfigurationPropertyUpdateService globalConfigurationPropertyUpdateService) {
        this.context = context;
        this.repository = repository;
        this.globalConfigurationDataValidator = globalConfigurationDataValidator;
        this.configurationDomainService = configurationDomainService;
        this.globalConfigurationPropertyUpdateService = globalConfigurationPropertyUpdateService;
    }
}

