/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.cob.loan;

import java.util.Optional;
import lombok.Generated;
import org.apache.fineract.cob.loan.LoanCOBBusinessStep;
import org.apache.fineract.infrastructure.core.diagnostics.performance.MeasuringUtil;
import org.apache.fineract.infrastructure.core.domain.ExternalId;
import org.apache.fineract.infrastructure.event.business.service.BusinessEventNotifierService;
import org.apache.fineract.portfolio.loanaccount.domain.Loan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class CheckDueInstallmentsBusinessStep
implements LoanCOBBusinessStep {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CheckDueInstallmentsBusinessStep.class);
    private final BusinessEventNotifierService businessEventNotifierService;

    public Loan execute(Loan loan) {
        if (loan == null) {
            log.debug("Ignoring custom snapshot event processing for null loan.");
            return null;
        }
        String externalId = Optional.ofNullable(loan.getExternalId()).map(ExternalId::getValue).orElse(null);
        MeasuringUtil.measure((Runnable)new /* Unavailable Anonymous Inner Class!! */, duration -> log.debug("Ending custom snapshot event processing for loan with Id [{}], account number [{}], external Id [{}], finished in [{}]ms.", new Object[]{loan.getId(), loan.getAccountNumber(), externalId, duration.toMillis()}));
        return loan;
    }

    public String getEnumStyledName() {
        return "CHECK_DUE_INSTALLMENTS";
    }

    public String getHumanReadableName() {
        return "Check Due Installments";
    }

    @Generated
    public CheckDueInstallmentsBusinessStep(BusinessEventNotifierService businessEventNotifierService) {
        this.businessEventNotifierService = businessEventNotifierService;
    }
}

