/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.rule;

import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.druid.sql.calcite.rel.DruidUnnestRel;

public class DruidFilterUnnestRule
extends RelOptRule {
    private static final DruidFilterUnnestRule INSTANCE = new DruidFilterUnnestRule();

    private DruidFilterUnnestRule() {
        super(DruidFilterUnnestRule.operand(Filter.class, (RelOptRuleOperand)DruidFilterUnnestRule.operand(DruidUnnestRel.class, (RelOptRuleOperandChildren)DruidFilterUnnestRule.any()), (RelOptRuleOperand[])new RelOptRuleOperand[0]));
    }

    public static DruidFilterUnnestRule instance() {
        return INSTANCE;
    }

    public void onMatch(RelOptRuleCall call) {
        Filter filter = (Filter)call.rel(0);
        DruidUnnestRel unnestDatasourceRel = (DruidUnnestRel)call.rel(1);
        DruidUnnestRel newRel = unnestDatasourceRel.withFilter(filter);
        call.transformTo((RelNode)newRel);
    }

    static class DruidProjectOnUnnestRule
    extends RelOptRule {
        private static final DruidProjectOnUnnestRule INSTANCE = new DruidProjectOnUnnestRule();

        private DruidProjectOnUnnestRule() {
            super(DruidProjectOnUnnestRule.operand(Project.class, (RelOptRuleOperand)DruidProjectOnUnnestRule.operand(DruidUnnestRel.class, (RelOptRuleOperandChildren)DruidProjectOnUnnestRule.any()), (RelOptRuleOperand[])new RelOptRuleOperand[0]));
        }

        public static DruidProjectOnUnnestRule instance() {
            return INSTANCE;
        }

        public boolean matches(RelOptRuleCall call) {
            Project rightP = (Project)call.rel(0);
            if (rightP.getProjects().size() > 0) {
                SqlKind rightProjectKind = ((RexNode)rightP.getProjects().get(0)).getKind();
                SqlTypeName projectType = ((RexNode)rightP.getProjects().get(0)).getType().getSqlTypeName();
                SqlTypeName unnestDataType = ((RelDataTypeField)call.rel(1).getRowType().getFieldList().get(0)).getType().getSqlTypeName();
                return rightP.getProjects().size() == 1 && (rightProjectKind == SqlKind.CAST || rightProjectKind == SqlKind.LITERAL) && projectType == unnestDataType;
            }
            return false;
        }

        public void onMatch(RelOptRuleCall call) {
            DruidUnnestRel unnestDatasourceRel = (DruidUnnestRel)call.rel(1);
            call.transformTo((RelNode)unnestDatasourceRel);
        }
    }
}

