/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.datasketches.tuple;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.aggregation.datasketches.tuple.ArrayOfDoublesSketchPostAggregator;

public abstract class ArrayOfDoublesSketchMultiPostAggregator
extends ArrayOfDoublesSketchPostAggregator {
    private final List<PostAggregator> fields;
    private Set<String> dependentFields;

    @JsonCreator
    public ArrayOfDoublesSketchMultiPostAggregator(String name, List<PostAggregator> fields) {
        super(name);
        this.fields = fields;
    }

    @Override
    public Set<String> getDependentFields() {
        if (this.dependentFields == null) {
            this.dependentFields = Sets.newHashSet(super.getDependentFields());
            for (PostAggregator field : this.fields) {
                this.dependentFields.addAll(field.getDependentFields());
            }
        }
        return this.dependentFields;
    }

    @JsonProperty
    public List<PostAggregator> getFields() {
        return this.fields;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{name='" + this.getName() + "', fields=" + String.valueOf(this.fields) + "}";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ArrayOfDoublesSketchMultiPostAggregator that = (ArrayOfDoublesSketchMultiPostAggregator)o;
        return this.fields.equals(that.fields);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.fields);
    }
}

