/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.indexing.error;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.RE;
import org.apache.druid.msq.exec.ControllerClient;
import org.apache.druid.msq.indexing.error.MSQErrorReport;
import org.apache.druid.msq.indexing.error.MSQWarningReportPublisher;

public class MSQWarningReportLimiterPublisher
implements MSQWarningReportPublisher {
    private final MSQWarningReportPublisher delegate;
    private final long totalLimit;
    private final Map<String, Long> errorCodeToLimit;
    private final Set<String> criticalWarningCodes;
    private final ConcurrentHashMap<String, Long> errorCodeToCurrentCount = new ConcurrentHashMap();
    private final ControllerClient controllerClient;
    private final String workerId;
    @Nullable
    private final String host;
    long totalCount = 0L;
    final Object lock = new Object();

    public MSQWarningReportLimiterPublisher(MSQWarningReportPublisher delegate, long totalLimit, Map<String, Long> errorCodeToLimit, Set<String> criticalWarningCodes, ControllerClient controllerClient, String workerId, @Nullable String host) {
        this.delegate = delegate;
        this.errorCodeToLimit = errorCodeToLimit;
        this.criticalWarningCodes = criticalWarningCodes;
        this.totalLimit = totalLimit;
        this.controllerClient = controllerClient;
        this.workerId = workerId;
        this.host = host;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void publishException(int stageNumber, Throwable e) {
        String errorCode = MSQErrorReport.getFaultFromException(e).getErrorCode();
        Object object = this.lock;
        synchronized (object) {
            ++this.totalCount;
            this.errorCodeToCurrentCount.compute(errorCode, (ignored, count) -> count == null ? 1L : count + 1L);
            if (this.criticalWarningCodes.contains(errorCode)) {
                try {
                    this.controllerClient.postWorkerError(MSQErrorReport.fromException(this.workerId, this.host, stageNumber, e));
                }
                catch (IOException postException) {
                    throw new RE((Throwable)postException, "Failed to post the worker error [%s] to the controller", new Object[]{errorCode});
                }
            }
            if (this.totalLimit != -1L && this.totalCount > this.totalLimit) {
                return;
            }
        }
        long limitForFault = this.errorCodeToLimit.getOrDefault(errorCode, -1L);
        Object object2 = this.lock;
        synchronized (object2) {
            if (limitForFault != -1L && this.errorCodeToCurrentCount.getOrDefault(errorCode, 0L) > limitForFault) {
                return;
            }
        }
        this.delegate.publishException(stageNumber, e);
    }
}

