/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.indexing.error;

import org.apache.druid.msq.indexing.error.MSQException;
import org.apache.druid.msq.indexing.error.MSQFault;

public class MSQFaultUtils {
    public static final String ERROR_CODE_DELIMITER = ": ";

    public static String generateMessageWithErrorCode(MSQFault msqFault) {
        String message = msqFault.getErrorMessage();
        if (message != null && !message.isEmpty()) {
            return msqFault.getErrorCode() + ERROR_CODE_DELIMITER + message;
        }
        return msqFault.getErrorCode();
    }

    public static String getErrorCodeFromMessage(String message) {
        if (message == null || message.isEmpty() || !message.contains(ERROR_CODE_DELIMITER)) {
            return "UnknownError";
        }
        return message.split(ERROR_CODE_DELIMITER, 2)[0];
    }

    public static boolean isCanceledException(Throwable t) {
        return t instanceof MSQException && ((MSQException)t).getFault().getErrorCode().equals("Canceled");
    }
}

