/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.join.table;

import it.unimi.dsi.fastutil.ints.IntSortedSet;
import it.unimi.dsi.fastutil.ints.IntSortedSets;
import javax.annotation.Nullable;
import org.apache.druid.segment.DimensionHandlerUtils;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.join.table.IndexedTable;

public class UniqueLongArrayIndex
implements IndexedTable.Index {
    private final int[] index;
    private final long minKey;

    UniqueLongArrayIndex(int[] index, long minKey) {
        this.index = index;
        this.minKey = minKey;
    }

    @Override
    public ColumnType keyType() {
        return ColumnType.LONG;
    }

    @Override
    public boolean areKeysUnique(boolean includeNull) {
        return true;
    }

    @Override
    public IntSortedSet find(@Nullable Object key) {
        int row;
        if (key == null) {
            return IntSortedSets.EMPTY_SET;
        }
        Long longKey = DimensionHandlerUtils.convertObjectToLong(key);
        if (longKey != null && (row = this.findUniqueLong(longKey)) >= 0) {
            return IntSortedSets.singleton((int)row);
        }
        return IntSortedSets.EMPTY_SET;
    }

    @Override
    public int findUniqueLong(long key) {
        if (key >= this.minKey && key < this.minKey + (long)this.index.length) {
            return this.index[(int)(key - this.minKey)];
        }
        return -1;
    }
}

