/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.index;

import org.apache.druid.collections.bitmap.BitmapFactory;
import org.apache.druid.query.BitmapResultFactory;
import org.apache.druid.query.filter.ColumnIndexSelector;
import org.apache.druid.segment.column.ColumnIndexCapabilities;
import org.apache.druid.segment.column.SimpleColumnIndexCapabilities;
import org.apache.druid.segment.index.BitmapColumnIndex;

public class AllTrueBitmapColumnIndex
implements BitmapColumnIndex {
    private final BitmapFactory bitmapFactory;
    private final int numRows;

    public AllTrueBitmapColumnIndex(BitmapFactory bitmapFactory, int numRows) {
        this.bitmapFactory = bitmapFactory;
        this.numRows = numRows;
    }

    public AllTrueBitmapColumnIndex(ColumnIndexSelector indexSelector) {
        this(indexSelector.getBitmapFactory(), indexSelector.getNumRows());
    }

    @Override
    public ColumnIndexCapabilities getIndexCapabilities() {
        return SimpleColumnIndexCapabilities.getConstant();
    }

    @Override
    public int estimatedComputeCost() {
        return 0;
    }

    @Override
    public <T> T computeBitmapResult(BitmapResultFactory<T> bitmapResultFactory, boolean includeUnknown) {
        return bitmapResultFactory.wrapAllTrue(this.bitmapFactory.complement(this.bitmapFactory.makeEmptyImmutableBitmap(), this.numRows));
    }
}

