/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.cardinality.types;

import org.apache.druid.java.util.common.IAE;
import org.apache.druid.query.aggregation.cardinality.types.CardinalityAggregatorColumnSelectorStrategy;
import org.apache.druid.query.aggregation.cardinality.types.DoubleCardinalityAggregatorColumnSelectorStrategy;
import org.apache.druid.query.aggregation.cardinality.types.FloatCardinalityAggregatorColumnSelectorStrategy;
import org.apache.druid.query.aggregation.cardinality.types.LongCardinalityAggregatorColumnSelectorStrategy;
import org.apache.druid.query.aggregation.cardinality.types.StringCardinalityAggregatorColumnSelectorStrategy;
import org.apache.druid.query.dimension.ColumnSelectorStrategyFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ValueType;

public class CardinalityAggregatorColumnSelectorStrategyFactory
implements ColumnSelectorStrategyFactory<CardinalityAggregatorColumnSelectorStrategy> {
    @Override
    public CardinalityAggregatorColumnSelectorStrategy makeColumnSelectorStrategy(ColumnCapabilities capabilities, ColumnValueSelector selector, String dimension) {
        switch ((ValueType)capabilities.getType()) {
            case STRING: {
                return new StringCardinalityAggregatorColumnSelectorStrategy();
            }
            case LONG: {
                return new LongCardinalityAggregatorColumnSelectorStrategy();
            }
            case FLOAT: {
                return new FloatCardinalityAggregatorColumnSelectorStrategy();
            }
            case DOUBLE: {
                return new DoubleCardinalityAggregatorColumnSelectorStrategy();
            }
        }
        throw new IAE("Cannot create query type helper from invalid type [%s]", capabilities.asTypeString());
    }

    @Override
    public boolean supportsComplexTypes() {
        return false;
    }
}

