/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Function;
import java.util.Collections;
import org.apache.druid.data.input.MapBasedRow;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.query.PostProcessingOperator;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.Result;
import org.apache.druid.query.context.ResponseContext;
import org.apache.druid.query.spec.MultipleIntervalSegmentSpec;
import org.apache.druid.query.timeboundary.TimeBoundaryQuery;
import org.apache.druid.query.timeboundary.TimeBoundaryResultValue;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Interval;
import org.joda.time.Period;

public class TimewarpOperator<T>
implements PostProcessingOperator<T> {
    private final Interval dataInterval;
    private final long periodMillis;
    private final long originMillis;

    @JsonCreator
    public TimewarpOperator(@JsonProperty(value="dataInterval") Interval dataInterval, @JsonProperty(value="period") Period period, @JsonProperty(value="origin") DateTime origin) {
        this.originMillis = origin.getMillis();
        this.dataInterval = dataInterval;
        this.periodMillis = period.toStandardDuration().getMillis();
    }

    @Override
    public QueryRunner<T> postProcess(QueryRunner<T> baseQueryRunner) {
        return this.postProcess(baseQueryRunner, DateTimes.nowUtc().getMillis());
    }

    public QueryRunner<T> postProcess(final QueryRunner<T> baseRunner, final long now) {
        return new QueryRunner<T>(){

            @Override
            public Sequence<T> run(final QueryPlus<T> queryPlus, ResponseContext responseContext) {
                DateTimeZone tz = queryPlus.getQuery().getTimezone();
                final long offset = TimewarpOperator.this.computeOffset(now, tz);
                Interval interval = queryPlus.getQuery().getIntervals().get(0);
                Interval modifiedInterval = new Interval(Math.min(interval.getStartMillis() + offset, now + offset), Math.min(interval.getEndMillis() + offset, now + offset), interval.getChronology());
                return Sequences.map(baseRunner.run(queryPlus.withQuery(queryPlus.getQuery().withQuerySegmentSpec(new MultipleIntervalSegmentSpec(Collections.singletonList(modifiedInterval)))), responseContext), new Function<T, T>(){

                    public T apply(T input) {
                        if (input instanceof Result) {
                            Result res = (Result)input;
                            Object value = res.getValue();
                            if (value instanceof TimeBoundaryResultValue) {
                                DateTime minTime;
                                TimeBoundaryResultValue boundary = (TimeBoundaryResultValue)value;
                                try {
                                    minTime = boundary.getMinTime();
                                }
                                catch (IllegalArgumentException e) {
                                    minTime = null;
                                }
                                DateTime maxTime = boundary.getMaxTime();
                                return ((TimeBoundaryQuery)queryPlus.getQuery()).buildResult(DateTimes.utc(Math.min(res.getTimestamp().getMillis() - offset, now)), minTime != null ? minTime.minus(offset) : null, maxTime != null ? DateTimes.utc(Math.min(maxTime.getMillis() - offset, now)) : null).iterator().next();
                            }
                            return new Result(res.getTimestamp().minus(offset), value);
                        }
                        if (input instanceof MapBasedRow) {
                            MapBasedRow row = (MapBasedRow)input;
                            return new MapBasedRow(row.getTimestamp().minus(offset), row.getEvent());
                        }
                        return input;
                    }
                });
            }
        };
    }

    protected long computeOffset(long t, DateTimeZone tz) {
        long start = this.dataInterval.getEndMillis() - this.periodMillis;
        long startOffset = start % this.periodMillis - this.originMillis % this.periodMillis;
        if (startOffset < 0L) {
            startOffset += this.periodMillis;
        }
        start -= startOffset;
        long tOffset = t % this.periodMillis - this.originMillis % this.periodMillis;
        if (tOffset < 0L) {
            tOffset += this.periodMillis;
        }
        return (tOffset += start) - t - (long)(tz.getOffset(tOffset) - tz.getOffset(t));
    }
}

