/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.processor.manager;

import com.google.common.collect.Iterators;
import java.util.function.Supplier;
import org.apache.druid.frame.processor.FrameProcessor;
import org.apache.druid.frame.processor.manager.ProcessorManager;
import org.apache.druid.frame.processor.manager.SequenceProcessorManager;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;

public class ProcessorManagers {
    private ProcessorManagers() {
    }

    public static <T> ProcessorManager<T, Long> none() {
        return ProcessorManagers.of(Sequences.empty());
    }

    public static <T> ProcessorManager<T, Long> of(Sequence<? extends FrameProcessor<T>> processors) {
        return new SequenceProcessorManager(processors);
    }

    public static <T> ProcessorManager<T, Long> of(Iterable<? extends FrameProcessor<T>> processors) {
        return ProcessorManagers.of(Sequences.simple(processors));
    }

    public static <T> ProcessorManager<T, Long> of(Supplier<? extends FrameProcessor<T>> processors) {
        return ProcessorManagers.of(Sequences.simple(() -> Iterators.singletonIterator((Object)((FrameProcessor)processors.get()))));
    }
}

