/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.rds.model.DescribeOptionGroupOptionsRequest;
import com.amazonaws.services.rds.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeOptionGroupOptionsRequestMarshaller
implements Marshaller<Request<DescribeOptionGroupOptionsRequest>, DescribeOptionGroupOptionsRequest> {
    public Request<DescribeOptionGroupOptionsRequest> marshall(DescribeOptionGroupOptionsRequest describeOptionGroupOptionsRequest) {
        if (describeOptionGroupOptionsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeOptionGroupOptionsRequest, "AmazonRDS");
        request.addParameter("Action", "DescribeOptionGroupOptions");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeOptionGroupOptionsRequest.getEngineName() != null) {
            request.addParameter("EngineName", StringUtils.fromString((String)describeOptionGroupOptionsRequest.getEngineName()));
        }
        if (describeOptionGroupOptionsRequest.getMajorEngineVersion() != null) {
            request.addParameter("MajorEngineVersion", StringUtils.fromString((String)describeOptionGroupOptionsRequest.getMajorEngineVersion()));
        }
        if (!describeOptionGroupOptionsRequest.getFilters().isEmpty() || !((SdkInternalList)describeOptionGroupOptionsRequest.getFilters()).isAutoConstruct()) {
            SdkInternalList filtersList = (SdkInternalList)describeOptionGroupOptionsRequest.getFilters();
            int filtersListIndex = 1;
            for (Filter filtersListValue : filtersList) {
                if (filtersListValue != null) {
                    if (filtersListValue.getName() != null) {
                        request.addParameter("Filters.Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)filtersListValue.getName()));
                    }
                    if (!filtersListValue.getValues().isEmpty() || !((SdkInternalList)filtersListValue.getValues()).isAutoConstruct()) {
                        SdkInternalList valuesList = (SdkInternalList)filtersListValue.getValues();
                        int valuesListIndex = 1;
                        for (String valuesListValue : valuesList) {
                            if (valuesListValue != null) {
                                request.addParameter("Filters.Filter." + filtersListIndex + ".Values.Value." + valuesListIndex, StringUtils.fromString((String)valuesListValue));
                            }
                            ++valuesListIndex;
                        }
                    }
                }
                ++filtersListIndex;
            }
        }
        if (describeOptionGroupOptionsRequest.getMaxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger((Integer)describeOptionGroupOptionsRequest.getMaxRecords()));
        }
        if (describeOptionGroupOptionsRequest.getMarker() != null) {
            request.addParameter("Marker", StringUtils.fromString((String)describeOptionGroupOptionsRequest.getMarker()));
        }
        return request;
    }
}

