/*
 * Decompiled with CFR 0.152.
 */
package com.ning.compress.lzf.impl;

import com.ning.compress.BufferRecycler;
import com.ning.compress.lzf.impl.UnsafeChunkEncoder;
import com.ning.compress.lzf.impl.UnsafeChunkEncoderBE;
import com.ning.compress.lzf.impl.UnsafeChunkEncoderLE;
import java.nio.ByteOrder;

public final class UnsafeChunkEncoders {
    private static final boolean LITTLE_ENDIAN = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN;

    public static UnsafeChunkEncoder createEncoder(int totalLength) {
        if (LITTLE_ENDIAN) {
            return new UnsafeChunkEncoderLE(totalLength);
        }
        return new UnsafeChunkEncoderBE(totalLength);
    }

    public static UnsafeChunkEncoder createNonAllocatingEncoder(int totalLength) {
        if (LITTLE_ENDIAN) {
            return new UnsafeChunkEncoderLE(totalLength, false);
        }
        return new UnsafeChunkEncoderBE(totalLength, false);
    }

    public static UnsafeChunkEncoder createEncoder(int totalLength, BufferRecycler bufferRecycler) {
        if (LITTLE_ENDIAN) {
            return new UnsafeChunkEncoderLE(totalLength, bufferRecycler);
        }
        return new UnsafeChunkEncoderBE(totalLength, bufferRecycler);
    }

    public static UnsafeChunkEncoder createNonAllocatingEncoder(int totalLength, BufferRecycler bufferRecycler) {
        if (LITTLE_ENDIAN) {
            return new UnsafeChunkEncoderLE(totalLength, bufferRecycler, false);
        }
        return new UnsafeChunkEncoderBE(totalLength, bufferRecycler, false);
    }
}

