/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.scriptengine;

import com.oracle.truffle.js.scriptengine.GraalJSEngineFactory;
import com.oracle.truffle.js.scriptengine.GraalJSScriptEngine;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Objects;
import javax.script.AbstractScriptEngine;
import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import javax.script.SimpleBindings;

public final class PlaceholderScriptEngine
extends AbstractScriptEngine {
    private static final String OUTPUT_PREFIX = "print(";
    private final GraalJSEngineFactory factory;

    PlaceholderScriptEngine(GraalJSEngineFactory factory) {
        this.factory = factory;
        this.setBindings(new PlaceholderBindings(), 100);
    }

    @Override
    public void setBindings(Bindings bindings, int scope) {
        Bindings engineBindings;
        if (scope == 100) {
            if (bindings instanceof PlaceholderBindings) {
                ((PlaceholderBindings)bindings).setGlobalBindings(this.getBindings(200));
            }
        } else if (scope == 200 && (engineBindings = this.getBindings(100)) instanceof PlaceholderBindings) {
            ((PlaceholderBindings)engineBindings).setGlobalBindings(bindings);
        }
        super.setBindings(bindings, scope);
    }

    @Override
    public Object eval(String script, ScriptContext ctx) throws ScriptException {
        Objects.requireNonNull(ctx);
        for (String statement : script.split(";")) {
            if (statement.isEmpty()) continue;
            if (!statement.endsWith(")")) {
                throw PlaceholderScriptEngine.error();
            }
            if (statement.startsWith(OUTPUT_PREFIX)) {
                try {
                    String output = statement.substring(OUTPUT_PREFIX.length(), statement.length() - 1);
                    ctx.getWriter().write(output);
                    continue;
                }
                catch (IOException ioex) {
                    throw new ScriptException(ioex);
                }
            }
            int dot = statement.indexOf(46);
            if (dot == -1) {
                throw PlaceholderScriptEngine.error();
            }
            int argsStart = statement.indexOf(40, dot);
            if (argsStart == -1) {
                throw PlaceholderScriptEngine.error();
            }
            String objectName = statement.substring(0, dot);
            String methodName = statement.substring(dot + 1, argsStart);
            String argsString = statement.substring(argsStart + 1, statement.length() - 1);
            String[] argNames = argsString.isEmpty() ? new String[]{} : argsString.split(",");
            Bindings bindings = ctx.getBindings(100);
            Object object = bindings.get(objectName);
            if (object == null) {
                throw PlaceholderScriptEngine.error();
            }
            Object[] args = new Object[argNames.length];
            Class[] argClasses = new Class[argNames.length];
            for (int i = 0; i < argNames.length; ++i) {
                Object arg = bindings.get(argNames[i]);
                if (arg == null) {
                    throw PlaceholderScriptEngine.error();
                }
                argClasses[i] = arg.getClass();
                args[i] = arg;
            }
            try {
                Method method = object.getClass().getMethod(methodName, argClasses);
                return method.invoke(object, args);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
                throw PlaceholderScriptEngine.error();
            }
        }
        return null;
    }

    private static ScriptException error() {
        return new ScriptException("JavaScript implementation not found!");
    }

    @Override
    public Object eval(Reader reader, ScriptContext ctx) throws ScriptException {
        return this.eval(GraalJSScriptEngine.read(reader), ctx);
    }

    @Override
    public Bindings createBindings() {
        return new PlaceholderBindings();
    }

    @Override
    public ScriptEngineFactory getFactory() {
        return this.factory;
    }

    private static final class PlaceholderBindings
    extends SimpleBindings {
        private Bindings globalBindings;

        private PlaceholderBindings() {
        }

        void setGlobalBindings(Bindings bindings) {
            this.globalBindings = bindings;
        }

        @Override
        public Object get(Object key) {
            return this.globalBindings == null || this.containsKey(key) ? super.get(key) : this.globalBindings.get(key);
        }
    }
}

