/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.datasketches.hll;

import java.nio.ByteBuffer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.datasketches.hll.TgtHllType;
import org.apache.datasketches.hll.Union;
import org.apache.druid.query.aggregation.VectorAggregator;
import org.apache.druid.query.aggregation.datasketches.hll.HllSketchHolder;
import org.apache.druid.query.aggregation.datasketches.hll.HllSketchMergeBufferAggregatorHelper;
import org.apache.druid.query.aggregation.datasketches.util.ToObjectVectorColumnProcessorFactory;
import org.apache.druid.segment.ColumnProcessors;
import org.apache.druid.segment.VectorColumnProcessorFactory;
import org.apache.druid.segment.vector.VectorColumnSelectorFactory;

public class HllSketchMergeVectorAggregator
implements VectorAggregator {
    private final HllSketchMergeBufferAggregatorHelper helper;
    private final Supplier<Object[]> objectSupplier;

    HllSketchMergeVectorAggregator(VectorColumnSelectorFactory columnSelectorFactory, String column, int lgK, TgtHllType tgtHllType, int size) {
        this.helper = new HllSketchMergeBufferAggregatorHelper(lgK, tgtHllType, size);
        this.objectSupplier = (Supplier)ColumnProcessors.makeVectorProcessor((String)column, (VectorColumnProcessorFactory)ToObjectVectorColumnProcessorFactory.INSTANCE, (VectorColumnSelectorFactory)columnSelectorFactory);
    }

    public void init(ByteBuffer buf, int position) {
        this.helper.init(buf, position);
    }

    public void aggregate(ByteBuffer buf, int position, int startRow, int endRow) {
        Object[] vector = this.objectSupplier.get();
        Union union = this.helper.getOrCreateUnion(buf, position);
        for (int i = startRow; i < endRow; ++i) {
            if (vector[i] == null) continue;
            union.update(((HllSketchHolder)vector[i]).getSketch());
        }
    }

    public void aggregate(ByteBuffer buf, int numRows, int[] positions, @Nullable int[] rows, int positionOffset) {
        Object[] vector = this.objectSupplier.get();
        for (int i = 0; i < numRows; ++i) {
            HllSketchHolder o = (HllSketchHolder)vector[rows != null ? rows[i] : i];
            if (o == null) continue;
            int position = positions[i] + positionOffset;
            Union union = this.helper.getOrCreateUnion(buf, position);
            union.update(o.getSketch());
        }
    }

    public Object get(ByteBuffer buf, int position) {
        return HllSketchHolder.of(this.helper.get(buf, position));
    }

    public void close() {
        this.helper.clear();
    }

    public void relocate(int oldPosition, int newPosition, ByteBuffer oldBuffer, ByteBuffer newBuffer) {
        this.helper.relocate(oldPosition, newPosition, oldBuffer, newBuffer);
    }
}

