/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.connection.ui.dialogs;

import org.apache.directory.api.util.Strings;
import org.apache.directory.studio.common.ui.CommonUIUtils;
import org.apache.directory.studio.common.ui.widgets.BaseWidgetUtils;
import org.apache.directory.studio.connection.ui.dialogs.Messages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SetupPasswordDialog
extends Dialog {
    private String title;
    private String message;
    private String value = "";
    private Button okButton;
    private Text passwordText;
    private Button showPasswordCheckbox;
    private Text verifyPasswordText;
    private Button showVerifyPasswordCheckbox;

    public SetupPasswordDialog(Shell parentShell, String title, String message, String initialValue) {
        super(parentShell);
        this.title = title;
        this.message = message;
        this.value = initialValue == null ? "" : initialValue;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(CommonUIUtils.getTextValue((String)this.title));
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.validate();
    }

    protected void buttonPressed(int buttonId) {
        this.value = buttonId == 0 ? this.passwordText.getText() : null;
        super.buttonPressed(buttonId);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        GridData compositeGridData = new GridData(4, 4, true, true);
        compositeGridData.widthHint = this.convertHorizontalDLUsToPixels(300);
        composite.setLayoutData((Object)compositeGridData);
        if (this.message != null) {
            Label messageLabel = BaseWidgetUtils.createWrappedLabel((Composite)composite, (String)this.message, (int)1);
            GridData messageLabelGridData = new GridData(4, 0x1000000, true, true);
            messageLabelGridData.widthHint = this.convertHorizontalDLUsToPixels(300);
            messageLabel.setLayoutData((Object)messageLabelGridData);
        }
        Group passwordGroup = BaseWidgetUtils.createGroup((Composite)composite, (String)Messages.getString("SetupPasswordDialog.Password"), (int)1);
        passwordGroup.setLayout((Layout)new GridLayout(2, false));
        BaseWidgetUtils.createLabel((Composite)passwordGroup, (String)Messages.getString("SetupPasswordDialog.PasswordColon"), (int)1);
        this.passwordText = BaseWidgetUtils.createText((Composite)passwordGroup, (String)this.value, (int)1);
        this.passwordText.setEchoChar('\u2022');
        this.passwordText.addModifyListener(event -> this.validate());
        BaseWidgetUtils.createLabel((Composite)passwordGroup, (String)"", (int)1);
        this.showPasswordCheckbox = BaseWidgetUtils.createCheckbox((Composite)passwordGroup, (String)Messages.getString("SetupPasswordDialog.ShowPassword"), (int)1);
        this.showPasswordCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (SetupPasswordDialog.this.showPasswordCheckbox.getSelection()) {
                    SetupPasswordDialog.this.passwordText.setEchoChar('\u0000');
                } else {
                    SetupPasswordDialog.this.passwordText.setEchoChar('\u2022');
                }
            }
        });
        BaseWidgetUtils.createLabel((Composite)passwordGroup, (String)Messages.getString("SetupPasswordDialog.VerifyPasswordColon"), (int)1);
        this.verifyPasswordText = BaseWidgetUtils.createText((Composite)passwordGroup, (String)this.value, (int)1);
        this.verifyPasswordText.setEchoChar('\u2022');
        this.verifyPasswordText.addModifyListener(event -> this.validate());
        BaseWidgetUtils.createLabel((Composite)passwordGroup, (String)"", (int)1);
        this.showVerifyPasswordCheckbox = BaseWidgetUtils.createCheckbox((Composite)passwordGroup, (String)Messages.getString("SetupPasswordDialog.ShowPassword"), (int)1);
        this.showVerifyPasswordCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (SetupPasswordDialog.this.showVerifyPasswordCheckbox.getSelection()) {
                    SetupPasswordDialog.this.verifyPasswordText.setEchoChar('\u0000');
                } else {
                    SetupPasswordDialog.this.verifyPasswordText.setEchoChar('\u2022');
                }
            }
        });
        this.passwordText.setFocus();
        SetupPasswordDialog.applyDialogFont((Control)composite);
        return composite;
    }

    public String getPassword() {
        return this.value;
    }

    private void validate() {
        String password = this.passwordText.getText();
        String verifyPassword = this.verifyPasswordText.getText();
        this.okButton.setEnabled(!Strings.isEmpty((String)password) && password.equals(verifyPassword));
    }
}

