/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.memory.internal;

import java.lang.foreign.Arena;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.datasketches.memory.Buffer;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.MemoryRequestServer;
import org.apache.datasketches.memory.Resource;
import org.apache.datasketches.memory.WritableBuffer;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.memory.internal.ResourceImpl;
import org.testng.Assert;
import org.testng.annotations.Test;

public class NativeWritableMemoryImplTest {
    private static final MemoryRequestServer memReqSvr = Resource.defaultMemReqSvr;

    @Test
    public void checkNativeCapacityAndClose() throws Exception {
        int memCapacity = 64;
        WritableMemory wmem = WritableMemory.allocateDirect((long)memCapacity, (long)1L, (ByteOrder)ByteOrder.nativeOrder(), (MemoryRequestServer)memReqSvr, (Arena)Arena.ofConfined());
        Assert.assertEquals((long)memCapacity, (long)wmem.getCapacity());
        wmem.getArena().close();
        Assert.assertFalse((boolean)wmem.isAlive());
        try {
            wmem.getArena().close();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void checkPutGetBooleans() {
        boolean[] srcArray = new boolean[]{true, false, true, false, false, true, false, true};
        int len = srcArray.length;
        WritableMemory wmem = WritableMemory.allocate((int)len, (ByteOrder)ResourceImpl.NATIVE_BYTE_ORDER);
        for (int i = 0; i < len; ++i) {
            wmem.putBoolean((long)i, srcArray[i]);
        }
        boolean[] dstArray = new boolean[len];
        for (int i = 0; i < len; ++i) {
            dstArray[i] = wmem.getBoolean((long)i);
        }
        Assert.assertEquals((boolean[])srcArray, (boolean[])dstArray);
    }

    @Test
    public void checkPutGetBytes() {
        byte[] srcArray = new byte[]{1, -2, 3, -4, 5, -6, 7, -8};
        int len = srcArray.length;
        int half = len / 2;
        WritableMemory wmem = WritableMemory.allocate((int)len, (ByteOrder)ResourceImpl.NATIVE_BYTE_ORDER);
        wmem.putByte(0L, srcArray[0]);
        wmem.putByteArray(1L, srcArray, 1, 2);
        wmem.putByte(3L, srcArray[3]);
        for (int i = half; i < len; ++i) {
            wmem.putByte((long)i, srcArray[i]);
        }
        byte[] dstArray = new byte[len];
        dstArray[0] = wmem.getByte(0L);
        wmem.getByteArray(1L, dstArray, 1, 2);
        dstArray[3] = wmem.getByte(3L);
        for (int i = half; i < len; ++i) {
            dstArray[i] = wmem.getByte((long)i);
        }
        Assert.assertEquals((byte[])srcArray, (byte[])dstArray);
    }

    @Test
    public void checkPutGetNativeCharacters() {
        char[] srcArray = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h'};
        int len = srcArray.length;
        int half = len / 2;
        WritableMemory wmem = WritableMemory.allocate((int)(len * 2), (ByteOrder)ResourceImpl.NATIVE_BYTE_ORDER);
        wmem.putChar(0L, srcArray[0]);
        wmem.putCharArray(2L, srcArray, 1, 2);
        wmem.putChar(6L, srcArray[3]);
        for (int i = half; i < len; ++i) {
            wmem.putChar((long)(i * 2), srcArray[i]);
        }
        char[] dstArray = new char[len];
        dstArray[0] = wmem.getChar(0L);
        wmem.getCharArray(2L, dstArray, 1, 2);
        dstArray[3] = wmem.getChar(6L);
        for (int i = half; i < len; ++i) {
            dstArray[i] = wmem.getChar((long)(i * 2));
        }
        Assert.assertEquals((char[])srcArray, (char[])dstArray);
    }

    @Test
    public void checkPutGetNativeDoubles() {
        double[] srcArray = new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0};
        int len = srcArray.length;
        int half = len / 2;
        WritableMemory wmem = WritableMemory.allocate((int)(len * 8), (ByteOrder)ResourceImpl.NATIVE_BYTE_ORDER);
        wmem.putDouble(0L, srcArray[0]);
        wmem.putDoubleArray(8L, srcArray, 1, 2);
        wmem.putDouble(24L, srcArray[3]);
        for (int i = half; i < len; ++i) {
            wmem.putDouble((long)(i * 8), srcArray[i]);
        }
        double[] dstArray = new double[len];
        dstArray[0] = wmem.getDouble(0L);
        wmem.getDoubleArray(8L, dstArray, 1, 2);
        dstArray[3] = wmem.getDouble(24L);
        for (int i = half; i < len; ++i) {
            dstArray[i] = wmem.getDouble((long)(i * 8));
        }
        Assert.assertEquals((double[])srcArray, (double[])dstArray);
    }

    @Test
    public void checkPutGetNativeFloats() {
        float[] srcArray = new float[]{1.0f, 2.0f, 3.0f, 4.0f, 5.0f, 6.0f, 7.0f, 8.0f};
        int len = srcArray.length;
        int half = len / 2;
        WritableMemory wmem = WritableMemory.allocate((int)(len * 4), (ByteOrder)ResourceImpl.NATIVE_BYTE_ORDER);
        wmem.putFloat(0L, srcArray[0]);
        wmem.putFloatArray(4L, srcArray, 1, 2);
        wmem.putFloat(12L, srcArray[3]);
        for (int i = half; i < len; ++i) {
            wmem.putFloat((long)(i * 4), srcArray[i]);
        }
        float[] dstArray = new float[len];
        dstArray[0] = wmem.getFloat(0L);
        wmem.getFloatArray(4L, dstArray, 1, 2);
        dstArray[3] = wmem.getFloat(12L);
        for (int i = half; i < len; ++i) {
            dstArray[i] = wmem.getFloat((long)(i * 4));
        }
        Assert.assertEquals((float[])srcArray, (float[])dstArray);
    }

    @Test
    public void checkPutGetNativeInts() {
        int[] srcArray = new int[]{1, 2, 3, 4, 5, 6, 7, 8};
        int len = srcArray.length;
        int half = len / 2;
        WritableMemory wmem = WritableMemory.allocate((int)(len * 4), (ByteOrder)ResourceImpl.NATIVE_BYTE_ORDER);
        wmem.putInt(0L, srcArray[0]);
        wmem.putIntArray(4L, srcArray, 1, 2);
        wmem.putInt(12L, srcArray[3]);
        for (int i = half; i < len; ++i) {
            wmem.putInt((long)(i * 4), srcArray[i]);
        }
        int[] dstArray = new int[len];
        dstArray[0] = wmem.getInt(0L);
        wmem.getIntArray(4L, dstArray, 1, 2);
        dstArray[3] = wmem.getInt(12L);
        for (int i = half; i < len; ++i) {
            dstArray[i] = wmem.getInt((long)(i * 4));
        }
        Assert.assertEquals((int[])srcArray, (int[])dstArray);
    }

    @Test
    public void checkPutGetNativeLongs() {
        long[] srcArray = new long[]{1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L};
        int len = srcArray.length;
        int half = len / 2;
        WritableMemory wmem = WritableMemory.allocate((int)(len * 8), (ByteOrder)ResourceImpl.NATIVE_BYTE_ORDER);
        wmem.putLong(0L, srcArray[0]);
        wmem.putLongArray(8L, srcArray, 1, 2);
        wmem.putLong(24L, srcArray[3]);
        for (int i = half; i < len; ++i) {
            wmem.putLong((long)(i * 8), srcArray[i]);
        }
        long[] dstArray = new long[len];
        dstArray[0] = wmem.getLong(0L);
        wmem.getLongArray(8L, dstArray, 1, 2);
        dstArray[3] = wmem.getLong(24L);
        for (int i = half; i < len; ++i) {
            dstArray[i] = wmem.getLong((long)(i * 8));
        }
        Assert.assertEquals((long[])srcArray, (long[])dstArray);
    }

    @Test
    public void checkPutGetNativeShorts() {
        short[] srcArray = new short[]{1, 2, 3, 4, 5, 6, 7, 8};
        int len = srcArray.length;
        int half = len / 2;
        WritableMemory wmem = WritableMemory.allocate((int)(len * 2), (ByteOrder)ResourceImpl.NATIVE_BYTE_ORDER);
        wmem.putShort(0L, srcArray[0]);
        wmem.putShortArray(2L, srcArray, 1, 2);
        wmem.putShort(6L, srcArray[3]);
        for (int i = half; i < len; ++i) {
            wmem.putShort((long)(i * 2), srcArray[i]);
        }
        short[] dstArray = new short[len];
        dstArray[0] = wmem.getShort(0L);
        wmem.getShortArray(2L, dstArray, 1, 2);
        dstArray[3] = wmem.getShort(6L);
        for (int i = half; i < len; ++i) {
            dstArray[i] = wmem.getShort((long)(i * 2));
        }
        Assert.assertEquals((short[])srcArray, (short[])dstArray);
    }

    @Test
    public void checkNativeBaseBound() throws Exception {
        int memCapacity = 64;
        try (Arena arena = Arena.ofConfined();){
            WritableMemory wmem = WritableMemory.allocateDirect((long)memCapacity, (long)1L, (ByteOrder)ByteOrder.nativeOrder(), (MemoryRequestServer)memReqSvr, (Arena)arena);
            wmem.toString("Force Assertion Error", (long)memCapacity, 8, false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void checkNativeSrcArrayBound() throws Exception {
        long memCapacity = 64L;
        try (Arena arena = Arena.ofConfined();){
            WritableMemory wmem = WritableMemory.allocateDirect((long)memCapacity, (long)1L, (ByteOrder)ByteOrder.nativeOrder(), (MemoryRequestServer)memReqSvr, (Arena)arena);
            byte[] srcArray = new byte[]{1, -2, 3, -4};
            wmem.putByteArray(0L, srcArray, 0, 5);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    public void checkDegenerateCopyTo() {
        WritableMemory wmem = WritableMemory.allocate((int)64);
        wmem.copyTo(0L, wmem, 0L, 64L);
    }

    @Test
    public void checkCopyWithinNativeSmall() throws Exception {
        int memCapacity = 64;
        int half = memCapacity / 2;
        try (Arena arena = Arena.ofConfined();){
            int i;
            WritableMemory wmem = WritableMemory.allocateDirect((long)memCapacity, (long)1L, (ByteOrder)ByteOrder.nativeOrder(), (MemoryRequestServer)memReqSvr, (Arena)arena);
            wmem.clear();
            for (i = 0; i < half; ++i) {
                wmem.putByte((long)i, (byte)i);
            }
            wmem.copyTo(0L, wmem, (long)half, (long)half);
            for (i = 0; i < half; ++i) {
                Assert.assertEquals((byte)wmem.getByte((long)(i + half)), (byte)((byte)i));
            }
        }
    }

    @Test
    public void checkCopyWithinNativeLarge() throws Exception {
        int memCapacity = 0x200040;
        int memCapLongs = memCapacity / 8;
        int halfBytes = memCapacity / 2;
        int halfLongs = memCapLongs / 2;
        try (Arena arena = Arena.ofConfined();){
            int i;
            WritableMemory wmem = WritableMemory.allocateDirect((long)memCapacity, (long)1L, (ByteOrder)ByteOrder.nativeOrder(), (MemoryRequestServer)memReqSvr, (Arena)arena);
            wmem.clear();
            for (i = 0; i < halfLongs; ++i) {
                wmem.putLong((long)(i * 8), (long)i);
            }
            wmem.copyTo(0L, wmem, (long)halfBytes, (long)halfBytes);
            for (i = 0; i < halfLongs; ++i) {
                Assert.assertEquals((long)wmem.getLong((long)((i + halfLongs) * 8)), (long)i);
            }
        }
    }

    @Test
    public void checkCopyWithinNativeSrcBound() throws Exception {
        int memCapacity = 64;
        try (Arena arena = Arena.ofConfined();){
            WritableMemory wmem = WritableMemory.allocateDirect((long)memCapacity, (long)1L, (ByteOrder)ByteOrder.nativeOrder(), (MemoryRequestServer)memReqSvr, (Arena)arena);
            wmem.copyTo(32L, wmem, 32L, 33L);
            Assert.fail((String)"Did Not Catch Assertion Error: source bound");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    public void checkCopyWithinNativeDstBound() throws Exception {
        int memCapacity = 64;
        try (Arena arena = Arena.ofConfined();){
            WritableMemory wmem = WritableMemory.allocateDirect((long)memCapacity, (long)1L, (ByteOrder)ByteOrder.nativeOrder(), (MemoryRequestServer)memReqSvr, (Arena)arena);
            wmem.copyTo(0L, wmem, 32L, 33L);
            Assert.fail((String)"Did Not Catch Assertion Error: dst bound");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    public void checkCopyCrossNativeSmall() throws Exception {
        int memCapacity = 64;
        try (Arena arena = Arena.ofConfined();){
            int i;
            WritableMemory wmem1 = WritableMemory.allocateDirect((long)memCapacity, (long)1L, (ByteOrder)ByteOrder.nativeOrder(), (MemoryRequestServer)memReqSvr, (Arena)arena);
            WritableMemory wmem2 = WritableMemory.allocateDirect((long)memCapacity, (long)1L, (ByteOrder)ByteOrder.nativeOrder(), (MemoryRequestServer)memReqSvr, (Arena)arena);
            for (i = 0; i < memCapacity; ++i) {
                wmem1.putByte((long)i, (byte)i);
            }
            wmem2.clear();
            wmem1.copyTo(0L, wmem2, 0L, (long)memCapacity);
            for (i = 0; i < memCapacity; ++i) {
                Assert.assertEquals((byte)wmem2.getByte((long)i), (byte)((byte)i));
            }
        }
    }

    @Test
    public void checkCopyCrossNativeLarge() throws Exception {
        int memCapacity = 0x200040;
        int memCapLongs = memCapacity / 8;
        try (Arena arena = Arena.ofConfined();){
            int i;
            WritableMemory wmem1 = WritableMemory.allocateDirect((long)memCapacity, (long)1L, (ByteOrder)ByteOrder.nativeOrder(), (MemoryRequestServer)memReqSvr, (Arena)arena);
            WritableMemory wmem2 = WritableMemory.allocateDirect((long)memCapacity, (long)1L, (ByteOrder)ByteOrder.nativeOrder(), (MemoryRequestServer)memReqSvr, (Arena)arena);
            for (i = 0; i < memCapLongs; ++i) {
                wmem1.putLong((long)(i * 8), (long)i);
            }
            wmem2.clear();
            wmem1.copyTo(0L, wmem2, 0L, (long)memCapacity);
            for (i = 0; i < memCapLongs; ++i) {
                Assert.assertEquals((long)wmem2.getLong((long)(i * 8)), (long)i);
            }
        }
    }

    @Test
    public void checkCopyCrossNativeAndByteArray() throws Exception {
        int memCapacity = 64;
        try (Arena arena = Arena.ofConfined();){
            WritableMemory wmem = WritableMemory.allocateDirect((long)memCapacity, (long)1L, (ByteOrder)ByteOrder.nativeOrder(), (MemoryRequestServer)memReqSvr, (Arena)arena);
            int i = 0;
            while ((long)i < wmem.getCapacity()) {
                wmem.putByte((long)i, (byte)i);
                ++i;
            }
            WritableMemory wmem2 = WritableMemory.allocate((int)memCapacity);
            wmem.copyTo(8L, wmem2, 16L, 16L);
            for (int i2 = 0; i2 < 16; ++i2) {
                Assert.assertEquals((byte)wmem.getByte((long)(8 + i2)), (byte)wmem2.getByte((long)(16 + i2)));
            }
        }
    }

    @Test
    public void checkCopyCrossRegionsSameNative() throws Exception {
        int memCapacity = 128;
        try (Arena arena = Arena.ofConfined();){
            WritableMemory wmem1 = WritableMemory.allocateDirect((long)memCapacity, (long)1L, (ByteOrder)ByteOrder.nativeOrder(), (MemoryRequestServer)memReqSvr, (Arena)arena);
            int i = 0;
            while ((long)i < wmem1.getCapacity()) {
                wmem1.putByte((long)i, (byte)i);
                ++i;
            }
            Memory reg1 = wmem1.region(8L, 16L);
            WritableMemory reg2 = wmem1.writableRegion(24L, 16L);
            reg1.copyTo(0L, reg2, 0L, 16L);
            for (int i2 = 0; i2 < 16; ++i2) {
                Assert.assertEquals((byte)reg1.getByte((long)i2), (byte)reg2.getByte((long)i2));
                Assert.assertEquals((byte)wmem1.getByte((long)(8 + i2)), (byte)wmem1.getByte((long)(24 + i2)));
            }
        }
    }

    @Test
    public void checkCopyCrossNativeArrayAndHierarchicalRegions() throws Exception {
        int memCapacity = 64;
        try (Arena arena = Arena.ofConfined();){
            WritableMemory wmem1 = WritableMemory.allocateDirect((long)memCapacity, (long)1L, (ByteOrder)ByteOrder.nativeOrder(), (MemoryRequestServer)memReqSvr, (Arena)arena);
            int i = 0;
            while ((long)i < wmem1.getCapacity()) {
                wmem1.putByte((long)i, (byte)i);
                ++i;
            }
            WritableMemory wmem2 = WritableMemory.allocate((int)memCapacity);
            Memory reg1 = wmem1.region(8L, 32L);
            Memory reg1B = reg1.region(8L, 16L);
            WritableMemory reg2 = wmem2.writableRegion(32L, 16L);
            reg1B.copyTo(0L, reg2, 0L, 16L);
            int i2 = 32;
            int j = 16;
            while (i2 < 40) {
                Assert.assertEquals((int)wmem2.getByte((long)i2), (int)j);
                ++i2;
                ++j;
            }
        }
    }

    @Test(expectedExceptions={IndexOutOfBoundsException.class})
    public void checkRegionBounds() throws Exception {
        int memCapacity = 64;
        try (Arena arena = Arena.ofConfined();){
            WritableMemory wmem = WritableMemory.allocateDirect((long)memCapacity, (long)1L, (ByteOrder)ByteOrder.nativeOrder(), (MemoryRequestServer)memReqSvr, (Arena)arena);
            wmem.writableRegion(1L, 64L);
        }
    }

    @Test
    public void checkByteBufferWrap() {
        int memCapacity = 64;
        ByteBuffer byteBuf = ByteBuffer.allocate(memCapacity);
        byteBuf.order(ByteOrder.nativeOrder());
        for (int i = 0; i < memCapacity; ++i) {
            byteBuf.put(i, (byte)i);
        }
        WritableMemory wmem = WritableMemory.writableWrap((ByteBuffer)byteBuf);
        for (int i = 0; i < memCapacity; ++i) {
            Assert.assertEquals((byte)wmem.getByte((long)i), (byte)byteBuf.get(i));
        }
        Assert.assertTrue((boolean)wmem.hasByteBuffer());
        ByteBuffer byteBuf2 = wmem.toByteBuffer(ByteOrder.nativeOrder());
        Assert.assertEquals((Object)byteBuf2, (Object)byteBuf);
    }

    @Test
    public void checkWrapWithBBReadonly1() {
        int memCapacity = 64;
        ByteBuffer byteBuf = ByteBuffer.allocate(memCapacity);
        byteBuf.order(ByteOrder.nativeOrder());
        for (int i = 0; i < memCapacity; ++i) {
            byteBuf.put(i, (byte)i);
        }
        WritableMemory mem = WritableMemory.writableWrap((ByteBuffer)byteBuf);
        for (int i = 0; i < memCapacity; ++i) {
            Assert.assertEquals((byte)mem.getByte((long)i), (byte)byteBuf.get(i));
        }
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void checkWrapWithBBReadonly2() {
        int memCapacity = 64;
        ByteBuffer byteBuf = ByteBuffer.allocate(memCapacity);
        byteBuf.order(ByteOrder.nativeOrder());
        ByteBuffer byteBufRO = byteBuf.asReadOnlyBuffer();
        WritableMemory.writableWrap((ByteBuffer)byteBufRO);
    }

    @Test
    public void checkWrapWithDirectBBReadonly() {
        int memCapacity = 64;
        ByteBuffer byteBuf = ByteBuffer.allocateDirect(memCapacity);
        byteBuf.order(ByteOrder.nativeOrder());
        for (int i = 0; i < memCapacity; ++i) {
            byteBuf.put(i, (byte)i);
        }
        ByteBuffer byteBufRO = byteBuf.asReadOnlyBuffer();
        byteBufRO.order(ByteOrder.nativeOrder());
        Memory mem = Memory.wrap((ByteBuffer)byteBufRO);
        for (int i = 0; i < memCapacity; ++i) {
            Assert.assertEquals((byte)mem.getByte((long)i), (byte)byteBuf.get(i));
        }
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void checkWrapWithDirectBBReadonlyPut() {
        int memCapacity = 64;
        ByteBuffer byteBuf = ByteBuffer.allocateDirect(memCapacity);
        ByteBuffer byteBufRO = byteBuf.asReadOnlyBuffer();
        byteBufRO.order(ByteOrder.nativeOrder());
        WritableMemory.writableWrap((ByteBuffer)byteBufRO);
    }

    @Test
    public void checkByteBufferWrapDirectAccess() {
        int memCapacity = 64;
        ByteBuffer byteBuf = ByteBuffer.allocateDirect(memCapacity);
        byteBuf.order(ByteOrder.nativeOrder());
        for (int i = 0; i < memCapacity; ++i) {
            byteBuf.put(i, (byte)i);
        }
        Memory mem = Memory.wrap((ByteBuffer)byteBuf);
        for (int i = 0; i < memCapacity; ++i) {
            Assert.assertEquals((byte)mem.getByte((long)i), (byte)byteBuf.get(i));
        }
    }

    @Test
    public void checkIsDirect() throws Exception {
        int memCapacity = 64;
        try (Arena arena = Arena.ofConfined();){
            WritableMemory mem = WritableMemory.allocate((int)memCapacity);
            Assert.assertFalse((boolean)mem.isDirect());
            WritableMemory wmem = WritableMemory.allocateDirect((long)memCapacity, (long)1L, (ByteOrder)ByteOrder.nativeOrder(), (MemoryRequestServer)memReqSvr, (Arena)arena);
            Assert.assertTrue((boolean)wmem.isDirect());
        }
    }

    @Test
    public void checkIsReadOnly() {
        long[] srcArray = new long[]{1L, -2L, 3L, -4L, 5L, -6L, 7L, -8L};
        WritableMemory wmem = WritableMemory.writableWrap((long[])srcArray);
        Assert.assertFalse((boolean)wmem.isReadOnly());
        WritableMemory memRO = wmem;
        Assert.assertFalse((boolean)memRO.isReadOnly());
        int i = 0;
        while ((long)i < wmem.getCapacity()) {
            Assert.assertEquals((byte)wmem.getByte((long)i), (byte)memRO.getByte((long)i));
            ++i;
        }
    }

    @Test
    public void checkGoodBounds() {
        ResourceImpl.checkBounds((long)50L, (long)50L, (long)100L);
    }

    @Test
    public void checkAsBuffer() {
        WritableMemory wmem = WritableMemory.allocate((int)64);
        WritableBuffer wbuf = wmem.asWritableBuffer();
        wbuf.setPosition(32L);
        for (int i = 32; i < 64; ++i) {
            wbuf.putByte((byte)i);
        }
        Buffer buf = wmem.asBuffer();
        buf.setPosition(32L);
        for (int i = 32; i < 64; ++i) {
            Assert.assertEquals((int)buf.getByte(), (int)i);
        }
    }

    @Test
    public void checkAsWritableBufferWithBB() {
        ByteBuffer byteBuf = ByteBuffer.allocate(64);
        byteBuf.position(16);
        byteBuf.limit(48);
        WritableMemory wmem = WritableMemory.writableWrap((ByteBuffer)byteBuf);
        WritableBuffer wbuf = wmem.asWritableBuffer();
        Assert.assertEquals((long)wbuf.getCapacity(), (long)64L);
        Assert.assertEquals((long)wbuf.getPosition(), (long)0L);
        Assert.assertEquals((long)wbuf.getEnd(), (long)64L);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void checkAsWritableRegionRO() {
        ByteBuffer byteBuf = ByteBuffer.allocate(64);
        WritableMemory wmem = (WritableMemory)Memory.wrap((ByteBuffer)byteBuf);
        wmem.writableRegion(0L, 1L);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void checkAsWritableBufferRO() {
        ByteBuffer byteBuf = ByteBuffer.allocate(64);
        WritableMemory wmem = (WritableMemory)Memory.wrap((ByteBuffer)byteBuf);
        wmem.asWritableBuffer();
    }

    @Test
    void checkZeroMemory() {
        WritableMemory wmem = WritableMemory.allocate((int)8);
        WritableMemory reg = wmem.writableRegion(0L, 0L);
        Assert.assertEquals((long)reg.getCapacity(), (long)0L);
    }

    @Test
    public void checkAsBufferNonNative() {
        WritableMemory wmem = WritableMemory.allocate((int)64);
        wmem.putShort(0L, (short)1);
        Buffer buf = wmem.asBuffer(ResourceImpl.NON_NATIVE_BYTE_ORDER);
        Assert.assertEquals((int)buf.getShort(0L), (int)256);
    }

    @Test
    public void printlnTest() {
        NativeWritableMemoryImplTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
    }
}

